/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;

@PipeBitInfo(name="Context Modality Annotator", description="Sets Modality based upon context.", dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class ContextualModalityAnnotator
extends CleartkAnnotator<String> {
    private CleartkExtractor contextExtractor;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ContextualModalityAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ContextualModalityAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ContextualModalityAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        CombinedExtractor1 baseExtractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"));
        this.contextExtractor = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)baseExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Covered(), new CleartkExtractor.Following(3)});
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
            String outcome;
            if (eventMention.getEvent() == null) continue;
            List features = this.contextExtractor.extract(jCas, (Annotation)eventMention);
            if (this.isTraining()) {
                outcome = eventMention.getEvent().getProperties().getContextualModality();
                this.dataWriter.write(new Instance((Object)outcome, (Collection)features));
                continue;
            }
            outcome = (String)this.classifier.classify(features);
            eventMention.getEvent().getProperties().setContextualModality(outcome);
        }
    }
}

