/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.token.adapter;

import org.apache.ctakes.core.fsm.token.IntegerToken;
import org.apache.ctakes.core.fsm.token.adapter.NumberTokenAdapter;
import org.apache.ctakes.core.nlp.tokenizer.Token;

public class IntegerTokenAdapter
extends NumberTokenAdapter
implements IntegerToken {
    private long iv_val;
    private double iv_double;
    static String negativeSign = "-";

    public IntegerTokenAdapter(Token tok) {
        super(tok);
        String numAsString = this.removeCommas(tok.getText());
        try {
            this.iv_val = Long.parseLong(numAsString);
        }
        catch (NumberFormatException e) {
            this.iv_val = numAsString.startsWith(negativeSign) ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        try {
            this.iv_double = Double.parseDouble(numAsString);
        }
        catch (NumberFormatException e) {
            this.iv_double = numAsString.startsWith(negativeSign) ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
    }

    @Override
    public long getValue() {
        return this.iv_val;
    }

    public double getValueAsDouble() {
        return this.iv_double;
    }
}

