/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.plaintext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.ctakes.core.cc.pretty.cell.AbstractItemCell;
import org.apache.ctakes.core.cc.pretty.cell.DefaultBaseItemCell;
import org.apache.ctakes.core.cc.pretty.cell.DefaultUmlsItemCell;
import org.apache.ctakes.core.cc.pretty.cell.EventCell;
import org.apache.ctakes.core.cc.pretty.cell.ItemCell;
import org.apache.ctakes.core.cc.pretty.cell.TimexCell;
import org.apache.ctakes.core.cc.pretty.row.DefaultItemRow;
import org.apache.ctakes.core.cc.pretty.row.ItemRow;
import org.apache.ctakes.core.cc.pretty.textspan.DefaultTextSpan;
import org.apache.ctakes.core.cc.pretty.textspan.TextSpan;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.OntologyConceptUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public final class PrettyTextWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"PrettyTextWriter");
    private static final String FILE_EXTENSION = ".pretty.txt";
    private String _outputDirPath;

    public void setOutputDirectory(String outputDirectoryPath) throws IllegalArgumentException, SecurityException {
        if (outputDirectoryPath == null || outputDirectoryPath.isEmpty()) {
            this._outputDirPath = "";
            LOGGER.debug((Object)("No Output Directory Path specified, using current working directory " + System.getProperty("user.dir")));
            return;
        }
        File outputDir = new File(outputDirectoryPath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDirectoryPath + " is not a valid directory path");
        }
        this._outputDirPath = outputDirectoryPath;
        LOGGER.debug((Object)("Output Directory Path set to " + this._outputDirPath));
    }

    public void process(JCas jcas) {
        LOGGER.info((Object)"Starting processing");
        String docId = DocumentIDAnnotationUtil.getDocumentIdForFile(jcas);
        File outputFile = this._outputDirPath == null || this._outputDirPath.isEmpty() ? new File(docId + FILE_EXTENSION) : new File(this._outputDirPath, docId + FILE_EXTENSION);
        this.writeFile(jcas, outputFile.getPath());
        LOGGER.info((Object)"Finished processing");
    }

    public void writeFile(JCas jCas, String outputFilePath) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));){
            Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
            for (Sentence sentence : sentences) {
                PrettyTextWriter.writeSentence(jCas, (AnnotationFS)sentence, writer);
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write pretty file " + outputFilePath));
            LOGGER.error((Object)ioE.getMessage());
        }
    }

    public static void writeSentence(JCas jcas, AnnotationFS sentence, BufferedWriter writer) throws IOException {
        Map<TextSpan, ItemCell> baseItemMap = PrettyTextWriter.createBaseItemMap(jcas, sentence);
        Map<Integer, Collection<ItemCell>> coveringItemMap = PrettyTextWriter.createCoveringItemMap(jcas, sentence, baseItemMap);
        ArrayList<ItemRow> itemRows = new ArrayList<ItemRow>();
        DefaultItemRow baseItemRow = new DefaultItemRow();
        baseItemMap.values().forEach(baseItemRow::addItemCell);
        itemRows.add(baseItemRow);
        itemRows.addAll(PrettyTextWriter.createItemRows(coveringItemMap));
        Map<Integer, Integer> offsetAdjustedMap = PrettyTextWriter.createOffsetAdjustedMap(itemRows);
        PrettyTextWriter.printItemRows(offsetAdjustedMap, itemRows, writer);
        PrettyTextWriter.printTLinks(jcas, sentence, writer);
        writer.newLine();
    }

    private static Map<TextSpan, ItemCell> createBaseItemMap(JCas jcas, AnnotationFS sentence) {
        int sentenceBegin = sentence.getBegin();
        List baseTokens = JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)sentence);
        HashMap<TextSpan, ItemCell> baseItemMap = new HashMap<TextSpan, ItemCell>();
        for (BaseToken baseToken : baseTokens) {
            DefaultTextSpan textSpan = new DefaultTextSpan((AnnotationFS)baseToken, sentenceBegin);
            if (textSpan.getWidth() == 0) continue;
            if (baseToken instanceof NewlineToken) {
                DefaultBaseItemCell itemCell = new DefaultBaseItemCell(textSpan, " ", "");
                baseItemMap.put(textSpan, itemCell);
                continue;
            }
            String tokenText = baseToken.getCoveredText();
            String tokenPos = PrettyTextWriter.getTokenPos(baseToken);
            DefaultBaseItemCell itemCell = new DefaultBaseItemCell(textSpan, tokenText, tokenPos);
            baseItemMap.put(textSpan, itemCell);
        }
        return baseItemMap;
    }

    private static Map<Integer, Collection<ItemCell>> createCoveringItemMap(JCas jcas, AnnotationFS sentence, Map<TextSpan, ItemCell> baseItemMap) {
        Collection<ItemCell> coveringAnnotations;
        Collection<ItemCell> coveredBaseItems;
        HashSet<DefaultTextSpan> usedTextSpans = new HashSet<DefaultTextSpan>();
        HashSet<AbstractItemCell> requiredCells = new HashSet<AbstractItemCell>();
        HashSet<EventCell> eventCells = new HashSet<EventCell>();
        int sentenceBegin = sentence.getBegin();
        List identifiedAnnotations = JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, (AnnotationFS)sentence);
        for (IdentifiedAnnotation annotation : identifiedAnnotations) {
            DefaultTextSpan defaultTextSpan = new DefaultTextSpan((AnnotationFS)annotation, sentenceBegin);
            if (defaultTextSpan.getWidth() == 0) continue;
            Map<String, Collection<String>> semanticCuis = PrettyTextWriter.getSemanticCuis(annotation);
            if (!semanticCuis.isEmpty()) {
                DefaultUmlsItemCell itemCell = new DefaultUmlsItemCell(defaultTextSpan, annotation.getPolarity(), semanticCuis);
                requiredCells.add(itemCell);
                usedTextSpans.add(defaultTextSpan);
                continue;
            }
            if (annotation instanceof TimeMention) {
                requiredCells.add(new TimexCell(defaultTextSpan));
                continue;
            }
            if (!(annotation instanceof EventMention)) continue;
            eventCells.add(new EventCell(defaultTextSpan, annotation.getPolarity()));
        }
        HashMap<Integer, Collection<ItemCell>> coveringAnnotationMap = new HashMap<Integer, Collection<ItemCell>>();
        for (ItemCell itemCell : requiredCells) {
            coveredBaseItems = PrettyTextWriter.getCoveredBaseItems(itemCell.getTextSpan(), baseItemMap);
            coveringAnnotations = (HashSet<ItemCell>)coveringAnnotationMap.get(coveredBaseItems.size());
            if (coveringAnnotations == null) {
                coveringAnnotations = new HashSet<ItemCell>();
                coveringAnnotationMap.put(coveredBaseItems.size(), coveringAnnotations);
            }
            coveringAnnotations.add(itemCell);
        }
        for (ItemCell itemCell : eventCells) {
            if (usedTextSpans.contains(itemCell.getTextSpan())) continue;
            coveredBaseItems = PrettyTextWriter.getCoveredBaseItems(itemCell.getTextSpan(), baseItemMap);
            coveringAnnotations = (Collection)coveringAnnotationMap.get(coveredBaseItems.size());
            if (coveringAnnotations == null) {
                coveringAnnotations = new HashSet();
                coveringAnnotationMap.put(coveredBaseItems.size(), coveringAnnotations);
            }
            coveringAnnotations.add(itemCell);
        }
        return coveringAnnotationMap;
    }

    private static Map<Integer, Integer> createOffsetAdjustedMap(Iterable<ItemRow> itemRows) {
        HashSet<Integer> offsets = new HashSet<Integer>();
        for (ItemRow itemRow : itemRows) {
            Collection<ItemCell> rowItemCells = itemRow.getItemCells();
            for (ItemCell itemCell : rowItemCells) {
                offsets.add(itemCell.getTextSpan().getBegin());
                offsets.add(itemCell.getTextSpan().getEnd());
            }
        }
        ArrayList offsetList = new ArrayList(offsets);
        Collections.sort(offsetList);
        HashMap<Integer, Integer> offsetAdjustedMap = new HashMap<Integer, Integer>(offsetList.size());
        for (Integer offset : offsetList) {
            offsetAdjustedMap.put(offset, offset);
        }
        for (ItemRow itemRow : itemRows) {
            Collection<ItemCell> rowItemCells = itemRow.getItemCells();
            for (ItemCell itemCell : rowItemCells) {
                int nowWidth;
                TextSpan textSpan = itemCell.getTextSpan();
                int needWidth = itemCell.getWidth();
                if (needWidth <= (nowWidth = (Integer)offsetAdjustedMap.get(textSpan.getEnd()) - (Integer)offsetAdjustedMap.get(textSpan.getBegin()))) continue;
                int delta = needWidth - nowWidth;
                offsetList.stream().filter(o -> o >= textSpan.getEnd()).forEach(o -> offsetAdjustedMap.put((Integer)o, (Integer)offsetAdjustedMap.get(o) + delta));
            }
        }
        return offsetAdjustedMap;
    }

    private static void printItemRows(Map<Integer, Integer> offsetAdjustedMap, Iterable<ItemRow> itemRows, BufferedWriter writer) throws IOException {
        int rowWidth = 0;
        for (int adjustedOffset : offsetAdjustedMap.values()) {
            rowWidth = Math.max(rowWidth, adjustedOffset);
        }
        boolean firstLine = true;
        for (ItemRow itemRow : itemRows) {
            int rowHeight = itemRow.getHeight();
            for (int i = 0; i < rowHeight; ++i) {
                String lineText = itemRow.getTextLine(i, rowWidth, offsetAdjustedMap);
                if (lineText.isEmpty()) continue;
                if (firstLine) {
                    writer.write("SENTENCE:  " + lineText);
                    firstLine = false;
                } else {
                    writer.write("           " + lineText);
                }
                writer.newLine();
            }
        }
    }

    private static void printTLinks(JCas jcas, AnnotationFS sentence, BufferedWriter writer) throws IOException {
        Collection tlinks = JCasUtil.select((JCas)jcas, TemporalTextRelation.class);
        if (tlinks == null || tlinks.isEmpty()) {
            return;
        }
        ArrayList<TemporalTextRelation> sentenceTlinks = new ArrayList<TemporalTextRelation>();
        DefaultTextSpan sentenceTextSpan = new DefaultTextSpan(sentence.getBegin(), sentence.getEnd());
        for (TemporalTextRelation tlink : tlinks) {
            Annotation argument1 = tlink.getArg1().getArgument();
            DefaultTextSpan argument1Span = new DefaultTextSpan((AnnotationFS)argument1, 0);
            if (!sentenceTextSpan.overlaps(argument1Span)) continue;
            sentenceTlinks.add(tlink);
        }
        if (sentenceTlinks.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("TLINKS:    ");
        for (TemporalTextRelation tlink : sentenceTlinks) {
            sb.append(tlink.getArg1().getArgument().getCoveredText()).append(" ");
            sb.append(tlink.getCategory()).append(" ");
            sb.append(tlink.getArg2().getArgument().getCoveredText()).append(" , ");
        }
        sb.setLength(sb.length() - 3);
        writer.write(sb.toString());
        writer.newLine();
    }

    private static Collection<ItemCell> getCoveredBaseItems(TextSpan textSpan, Map<TextSpan, ItemCell> baseItemMap) {
        return baseItemMap.entrySet().stream().filter(e -> ((TextSpan)e.getKey()).overlaps(textSpan)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static Collection<ItemRow> createItemRows(Map<Integer, Collection<ItemCell>> coveringItemMap) {
        ArrayList<Integer> sortedCounts = new ArrayList<Integer>(coveringItemMap.keySet());
        Collections.sort(sortedCounts);
        ArrayList<ItemRow> itemRows = new ArrayList<ItemRow>();
        for (Integer coveredCount : sortedCounts) {
            Collection<ItemCell> itemCells = coveringItemMap.get(coveredCount);
            for (ItemCell itemCell : itemCells) {
                ItemRow itemRow;
                boolean added = false;
                Iterator iterator = itemRows.iterator();
                while (iterator.hasNext() && !(added = (itemRow = (ItemRow)iterator.next()).addItemCell(itemCell))) {
                }
                if (added) continue;
                DefaultItemRow itemRow2 = new DefaultItemRow();
                itemRow2.addItemCell(itemCell);
                itemRows.add(itemRow2);
            }
        }
        return itemRows;
    }

    private static String getTokenPos(BaseToken baseToken) {
        if (!(baseToken instanceof WordToken)) {
            return "";
        }
        String tokenPos = baseToken.getPartOfSpeech();
        if (tokenPos == null) {
            return "";
        }
        return tokenPos;
    }

    private static Map<String, Collection<String>> getSemanticCuis(IdentifiedAnnotation identifiedAnnotation) {
        Collection<UmlsConcept> umlsConcepts = OntologyConceptUtil.getUmlsConcepts(identifiedAnnotation);
        if (umlsConcepts == null || umlsConcepts.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<String>> semanticCuis = new HashMap<String, Collection<String>>();
        for (UmlsConcept umlsConcept : umlsConcepts) {
            HashSet<String> cuis;
            String cui = PrettyTextWriter.trimTo8(umlsConcept.getCui());
            String tui = umlsConcept.getTui();
            String semanticName = SemanticGroup.getSemanticName(tui);
            if (semanticName.equals("Unknown")) {
                semanticName = PrettyTextWriter.trimTo8(identifiedAnnotation.getClass().getSimpleName());
            }
            if ((cuis = (HashSet<String>)semanticCuis.get(semanticName)) == null) {
                cuis = new HashSet<String>();
                semanticCuis.put(semanticName, cuis);
            }
            cuis.add(cui);
        }
        return semanticCuis;
    }

    private static String trimTo8(String text) {
        if (text.length() <= 8) {
            return text;
        }
        return "<" + text.substring(text.length() - 7, text.length());
    }
}

