/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.pipelines;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.assertion.eval.XMIReader;
import org.apache.ctakes.assertion.util.AssertionTreeUtils;
import org.apache.ctakes.assertion.util.SemanticClasses;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class GenerateTreeRepresentation {
    protected static Options options = new Options();
    private static SemanticClasses sems = null;
    private static PrintStream out = null;
    private static Logger log = Logger.getLogger(GenerateTreeRepresentation.class);

    public static void main(String[] args) throws UIMAException, IOException {
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (sems == null) {
            sems = new SemanticClasses(FileLocator.getAsStream((String)"org/apache/ctakes/assertion/all_cues.txt"));
        }
        out = new PrintStream(GenerateTreeRepresentation.options.outFile);
        List<File> trainFiles = Arrays.asList(GenerateTreeRepresentation.options.trainDirectory.listFiles());
        String[] paths = new String[trainFiles.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = trainFiles.get(i).getPath();
        }
        CollectionReader reader = CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[0]);
        while (casIter.hasNext()) {
            JCas jcas = casIter.next();
            GenerateTreeRepresentation.processDocument(jcas);
        }
        out.close();
    }

    private static void processDocument(JCas jcas) {
        log.info((Object)("Processing document: " + DocumentIDAnnotationUtil.getDocumentID((JCas)jcas)));
        Collection mentions = JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class);
        for (IdentifiedAnnotation mention : mentions) {
            if (!(mention instanceof EventMention) && !(mention instanceof EntityMention)) continue;
            SimpleTree tree = null;
            String label = null;
            if (GenerateTreeRepresentation.options.attributeType == ATTRIBUTE.NEG) {
                label = mention.getPolarity() == -1 ? "+1" : "-1";
                tree = GenerateTreeRepresentation.getNegationTree(jcas, mention, sems);
            } else if (GenerateTreeRepresentation.options.attributeType == ATTRIBUTE.UNC) {
                label = mention.getUncertainty() == 1 ? "+1" : "-1";
                tree = GenerateTreeRepresentation.getUncertaintyTree(jcas, mention, sems);
            } else {
                throw new IllegalArgumentException("Do not have this attribute type!");
            }
            out.print(label);
            out.print(" |BT| ");
            out.print(tree.toString());
            out.println(" |ET|");
            out.flush();
        }
    }

    public static SimpleTree getUncertaintyTree(JCas jcas, IdentifiedAnnotation mention, SemanticClasses sems) {
        SimpleTree tree = null;
        tree = AssertionTreeUtils.extractAboveLeftConceptTree(jcas, (Annotation)mention, sems);
        String treeStr = tree.toString();
        treeStr = treeStr.replace("CONCEPT", "CONCEPT" + mention.getTypeID());
        return SimpleTree.fromString((String)treeStr);
    }

    public static SimpleTree getNegationTree(JCas jcas, IdentifiedAnnotation mention, SemanticClasses sems) {
        SimpleTree tree = null;
        tree = AssertionTreeUtils.extractAboveLeftConceptTree(jcas, (Annotation)mention, sems);
        String treeStr = tree.toString();
        return SimpleTree.fromString((String)treeStr);
    }

    public static class Options {
        @Option(name="--train-dir", usage="specify the directory containing the XMI training files (for example, /NLP/Corpus/Relations/mipacq/xmi/train)", required=true)
        public File trainDirectory;
        @Option(name="--output", usage="The file to which the data points be written.", required=true)
        public File outFile;
        @Option(name="--attribute", required=false)
        public ATTRIBUTE attributeType = ATTRIBUTE.NEG;
    }

    static enum ATTRIBUTE {
        NEG,
        UNC;

    }
}

