/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank;

import com.googlecode.clearnlp.constituent.CTLib;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.propbank.PBArg;
import com.googlecode.clearnlp.propbank.PBInstance;
import com.googlecode.clearnlp.propbank.PBReader;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PBLib {
    public static final String SRL_REL = "rel";
    public static final String SRL_DSP = "DSP";
    public static final String SRL_DIS = "DIS";
    public static final String SRL_ARG0 = "ARG0";
    public static final String SRL_ARGM = "ARGM";
    public static final String SRL_ARGM_MOD = "ARGM-MOD";
    public static final String SRL_LINK = "LINK";
    public static final String SRL_LINK_SLC = "LINK-SLC";
    public static final String SRL_LINK_PRO = "LINK-PRO";
    public static final String SRL_LINK_PSV = "LINK-PSV";
    public static final String SRL_C_V = "C-V";
    public static final String DELIM_LOC = ":";
    public static final String DELIM_LABEL = "-";
    public static final String DELIM_INST = " ";
    public static final String LOC_TYPES = "*&,;";
    public static final Pattern ILLEGAL_ROLESET = Pattern.compile(".*\\.(ER|NN|IE|YY)");

    public static List<PBInstance> getPBInstanceList(String propFile) {
        PBInstance instance;
        ArrayList<PBInstance> list = new ArrayList<PBInstance>();
        PBReader reader = new PBReader(UTInput.createBufferedFileReader(propFile));
        while ((instance = reader.nextInstance()) != null) {
            list.add(instance);
        }
        reader.close();
        Collections.sort(list);
        return list;
    }

    public static List<PBInstance> getPBInstanceList(String propFile, String treeDir, boolean norm) {
        List<PBInstance> list = PBLib.getPBInstanceList(propFile);
        CTReader reader = new CTReader();
        CTTree tree = null;
        String treeFile = "";
        int treeId = -1;
        for (PBInstance instance : list) {
            if (!treeFile.equals(instance.treePath)) {
                treeFile = instance.treePath;
                treeId = -1;
                reader.close();
                reader.open(UTInput.createBufferedFileReader(treeDir + File.separator + treeFile));
            }
            while (treeId < instance.treeId) {
                tree = reader.nextTree();
                ++treeId;
            }
            if (norm) {
                CTLib.normalizeIndices(tree);
            }
            tree.setPBLocs();
            instance.setTree(tree);
        }
        return list;
    }

    public static Map<String, List<PBInstance>> getPBInstanceMap(String propFile, String treeDir, boolean norm) {
        HashMap<String, List<PBInstance>> map = new HashMap<String, List<PBInstance>>();
        ArrayList<PBInstance> list = null;
        String prevkey = "";
        for (PBInstance inst : PBLib.getPBInstanceList(propFile, treeDir, norm)) {
            String currkey = PBLib.getTreePathId(inst);
            if (!currkey.equals(prevkey)) {
                list = new ArrayList<PBInstance>();
                prevkey = currkey;
                map.put(currkey, list);
            }
            list.add(inst);
        }
        return map;
    }

    private static String getTreePathId(PBInstance inst) {
        StringBuilder build = new StringBuilder();
        build.append(inst.treePath);
        build.append(DELIM_INST);
        build.append(inst.treeId);
        return build.toString();
    }

    public static void printPBInstances(List<PBInstance> instances, String outputFile) {
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        for (PBInstance instance : instances) {
            fout.println(instance.toString());
        }
        fout.close();
    }

    public static boolean isNumberedArgument(PBArg arg) {
        return arg.label.length() >= 4 && Character.isDigit(arg.label.charAt(3));
    }
}

