/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.nlp;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.component.dep.CDEPBackParser;
import com.googlecode.clearnlp.component.dep.CDEPPassParser;
import com.googlecode.clearnlp.component.morph.CDefaultMPAnalyzer;
import com.googlecode.clearnlp.component.morph.CEnglishMPAnalyzer;
import com.googlecode.clearnlp.component.pos.CPOSTagger;
import com.googlecode.clearnlp.component.srl.CPredIdentifier;
import com.googlecode.clearnlp.component.srl.CRolesetClassifier;
import com.googlecode.clearnlp.component.srl.CSRLabeler;
import com.googlecode.clearnlp.component.srl.CSenseClassifier;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.AbstractNLP;
import com.googlecode.clearnlp.reader.AbstractReader;
import com.googlecode.clearnlp.reader.JointReader;
import com.googlecode.clearnlp.reader.LineReader;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.UTXml;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NLPDecode
extends AbstractNLP {
    @Option(name="-c", usage="configuration file (required)", required=true, metaVar="<filename>")
    private String s_configXml;
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";
    @Option(name="-oe", usage="output file extension (default: cnlp)", required=false, metaVar="<string>")
    private String s_outputExt = "cnlp";
    @Option(name="-z", usage="mode (pos|morph|dep|srl|sense_vn)", required=true, metaVar="<string>")
    protected String s_mode;
    @Option(name="-twit", usage="if set, tokenize for twits", required=false, metaVar="<boolean>")
    protected boolean b_twit;
    @Option(name="-beams", usage="beam size (default: 1)", required=false, metaVar="<boolean>")
    protected int n_beams = 1;

    public NLPDecode() {
    }

    public NLPDecode(String[] args) {
        this.initArgs(args);
        try {
            this.decode(this.s_configXml, this.s_inputPath, this.s_inputExt, this.s_outputExt, this.s_mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void decode(String configXml, String inputPath, String inputExt, String outputExt, String mode) throws Exception {
        List<String[]> filenames = this.getFilenames(inputPath, inputExt, outputExt);
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configXml));
        Element eReader = UTXml.getFirstElementByTagName(eConfig, "reader");
        Element eModels = UTXml.getFirstElementByTagName(eConfig, "models");
        AbstractReader<?> reader = this.getReader(eReader);
        String readerType = reader.getType();
        AbstractSegmenter segmenter = readerType.equals("raw") ? this.getSegmenter(eModels, this.b_twit) : null;
        AbstractTokenizer tokenizer = readerType.equals("line") ? this.getTokenizer(eModels, this.b_twit) : null;
        AbstractComponent[] components = this.getComponent(eModels, this.getModes(readerType, mode));
        System.out.println("Decoding:");
        for (String[] filename : filenames) {
            reader.open(UTInput.createBufferedFileReader(filename[0]));
            PrintStream fout = UTOutput.createPrintBufferedFileStream(filename[1]);
            System.out.println(filename[0]);
            this.decode(reader, fout, segmenter, tokenizer, components, mode);
            reader.close();
            fout.close();
        }
    }

    public void decode(AbstractReader<?> reader, PrintStream fout, AbstractSegmenter segmenter, AbstractTokenizer tokenizer, AbstractComponent[] components, String mode) throws IOException {
        if (segmenter != null) {
            this.decode(reader.getBufferedReader(), fout, segmenter, components, mode);
        } else if (tokenizer != null) {
            this.decode((LineReader)reader, fout, tokenizer, components, mode);
        } else {
            this.decode((JointReader)reader, fout, components, mode);
        }
    }

    public void decode(BufferedReader reader, PrintStream fout, AbstractSegmenter segmenter, AbstractComponent[] components, String mode) throws IOException {
        for (List<String> tokens : segmenter.getSentences(reader)) {
            DEPTree tree = this.toDEPTree(tokens);
            for (AbstractComponent component : components) {
                component.process(tree);
            }
            fout.println(this.toString(tree, mode) + "\n");
        }
    }

    public void decode(LineReader reader, PrintStream fout, AbstractTokenizer tokenizer, AbstractComponent[] components, String mode) {
        String sentence;
        while ((sentence = reader.next()) != null) {
            DEPTree tree = this.toDEPTree(tokenizer.getTokens(sentence));
            for (AbstractComponent component : components) {
                component.process(tree);
            }
            fout.println(this.toString(tree, mode) + "\n");
        }
    }

    public void decode(JointReader reader, PrintStream fout, AbstractComponent[] components, String mode) {
        DEPTree tree;
        while ((tree = reader.next()) != null) {
            for (AbstractComponent component : components) {
                component.process(tree);
            }
            fout.println(this.toString(tree, mode) + "\n");
        }
    }

    public DEPTree toDEPTree(List<String> tokens) {
        DEPTree tree = new DEPTree();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            tree.add(new DEPNode(i + 1, tokens.get(i)));
        }
        return tree;
    }

    public AbstractComponent getComponent(InputStream stream, String language, String mode) throws IOException {
        ZipInputStream zin = new ZipInputStream(stream);
        if (mode.equals("pos")) {
            return new CPOSTagger(zin);
        }
        if (mode.equals("morph")) {
            return this.getMPAnalyzer(zin, language);
        }
        if (mode.equals("dep")) {
            return new CDEPPassParser(zin);
        }
        if (mode.equals("pred")) {
            return new CPredIdentifier(zin);
        }
        if (mode.equals("role")) {
            return new CRolesetClassifier(zin);
        }
        if (mode.startsWith("sense")) {
            return new CSenseClassifier(zin, mode.substring(mode.lastIndexOf("_") + 1));
        }
        if (mode.equals("srl")) {
            return new CSRLabeler(zin);
        }
        if (mode.equals("dep_back")) {
            return new CDEPBackParser(zin);
        }
        throw new IllegalArgumentException("The requested mode '" + mode + "' is not supported.");
    }

    private AbstractComponent getMPAnalyzer(ZipInputStream zin, String language) throws IOException {
        if (language.equals("en")) {
            return new CEnglishMPAnalyzer(zin);
        }
        return new CDefaultMPAnalyzer();
    }

    public List<String> getModes(String readerType, String mode) {
        ArrayList<String> modes = new ArrayList<String>();
        if (mode.equals("pos")) {
            modes.add("pos");
        }
        if (mode.equals("morph")) {
            if (readerType.equals("raw") || readerType.equals("line") || readerType.equals("tok")) {
                modes.add("pos");
            }
            modes.add("morph");
        } else if (mode.equals("dep")) {
            if (readerType.equals("raw") || readerType.equals("line") || readerType.equals("tok")) {
                modes.add("pos");
                modes.add("morph");
            } else if (readerType.equals("pos")) {
                modes.add("morph");
            }
            modes.add("dep");
        } else if (mode.equals("pred") || mode.equals("role") || mode.startsWith("sense")) {
            modes.add(mode);
        } else if (mode.equals("srl")) {
            if (readerType.equals("raw") || readerType.equals("line") || readerType.equals("tok")) {
                modes.add("pos");
                modes.add("morph");
                modes.add("dep");
            } else if (readerType.equals("pos")) {
                modes.add("morph");
                modes.add("dep");
            } else if (readerType.equals("morph")) {
                modes.add("dep");
            }
            modes.add("pred");
            modes.add("role");
            modes.add("srl");
        } else if (mode.equals("dep_back")) {
            if (readerType.equals("raw") || readerType.equals("line") || readerType.equals("tok")) {
                modes.add("pos");
                modes.add("morph");
            } else if (readerType.equals("pos")) {
                modes.add("morph");
            }
            modes.add("dep_back");
        }
        return modes;
    }

    protected AbstractComponent[] getComponent(Element eModels, List<String> modes) throws Exception {
        AbstractComponent[] components = new AbstractComponent[modes.size()];
        NodeList list = eModels.getElementsByTagName("model");
        ObjectIntOpenHashMap<String> map = this.getModeMap(modes);
        String language = this.getLanguage(eModels);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Element eModel = (Element)list.item(i);
            String mode = UTXml.getTrimmedAttribute(eModel, "mode");
            int idx = map.get((Object)mode) - 1;
            if (idx < 0) continue;
            components[idx] = this.getComponent(new FileInputStream(UTXml.getTrimmedAttribute(eModel, "path")), language, mode);
        }
        return components;
    }

    protected AbstractSegmenter getSegmenter(Element eModels, boolean twit) throws IOException {
        AbstractTokenizer tokenizer = this.getTokenizer(eModels, twit);
        String language = this.getLanguage(eModels);
        return EngineGetter.getSegmenter(language, tokenizer);
    }

    protected AbstractTokenizer getTokenizer(Element eModels, boolean twit) throws IOException {
        String language = this.getLanguage(eModels);
        String dictionary = this.getDictionary(eModels);
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer(language, new FileInputStream(dictionary));
        tokenizer.setTwit(twit);
        return tokenizer;
    }

    private ObjectIntOpenHashMap<String> getModeMap(List<String> modes) {
        ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
        int size = modes.size();
        for (int i = 0; i < size; ++i) {
            map.put((Object)modes.get(i), i + 1);
        }
        return map;
    }

    public static void main(String[] args) {
        new NLPDecode(args);
    }
}

