/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.ae;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.ListFactory;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textsem.Predicate;
import org.apache.ctakes.typesystem.type.textsem.SemanticArgument;
import org.apache.ctakes.typesystem.type.textsem.SemanticRoleRelation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"org.apache.ctakes.typesystem.type.syntax.BaseToken:partOfSpeech", "org.apache.ctakes.typesystem.type.syntax.BaseToken:tokenNumber", "org.apache.ctakes.typesystem.type.syntax.BaseToken:end", "org.apache.ctakes.typesystem.type.syntax.BaseToken:begin", "org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode"})
@PipeBitInfo(name="ClearNLP Semantic Role Labeler", description="Adds Semantic Roles Relations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.DEPENDENCY_NODE}, products={PipeBitInfo.TypeProduct.SEMANTIC_RELATION})
public class ClearNLPSemanticRoleLabelerAE
extends JCasAnnotator_ImplBase {
    final String language = "en";
    public Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String DEFAULT_SRL_MODEL_FILE_NAME = "org/apache/ctakes/dependency/parser/models/srl/mayo-en-srl-1.3.0.jar";
    public static final String DEFAULT_PRED_MODEL_FILE_NAME = "org/apache/ctakes/dependency/parser/models/pred/mayo-en-pred-1.3.0.jar";
    public static final String DEFAULT_ROLE_MODEL_FILE_NAME = "org/apache/ctakes/dependency/parser/models/role/mayo-en-role-1.3.0.jar";
    public static final String PARAM_PARSER_MODEL_FILE_NAME = "ParserModelFileName";
    public static final String PARAM_PRED_MODEL_FILE_NAME = "ParserPredFileName";
    public static final String PARAM_ROLE_MODEL_FILE_NAME = "ParserRoleFileName";
    protected URI srlModelUri;
    protected URI srlPredUri;
    protected URI srlRoleUri;
    @ConfigurationParameter(name="ParserModelFileName", description="This parameter provides the file name of the semantic role labeler model required by the factory method provided by ClearNLPUtil.", defaultValue={"org/apache/ctakes/dependency/parser/models/srl/mayo-en-srl-1.3.0.jar"})
    private String parserModelFileName;
    public static final String PARAM_LEMMATIZER_DATA_FILE = "LemmatizerDataFile";
    @ConfigurationParameter(name="ParserPredFileName", description="This parameter provides the file name of the pred model required by the factory method provided by ClearNLPUtil.", defaultValue={"org/apache/ctakes/dependency/parser/models/pred/mayo-en-pred-1.3.0.jar"})
    private String parserPredFileName;
    @ConfigurationParameter(name="ParserRoleFileName", description="This parameter provides the file name of the role model required by the factory method provided by ClearNLPUtil.", defaultValue={"org/apache/ctakes/dependency/parser/models/role/mayo-en-role-1.3.0.jar"})
    private String parserRoleFileName;
    protected AbstractComponent srlabeler;
    protected AbstractComponent identifier;
    protected AbstractComponent classifier;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            InputStream srlPred = this.srlPredUri == null ? FileLocator.getAsStream((String)DEFAULT_PRED_MODEL_FILE_NAME) : FileLocator.getAsStream((String)this.parserPredFileName);
            this.identifier = EngineGetter.getComponent((InputStream)srlPred, (String)this.language, (String)"pred");
            InputStream srlRole = this.srlRoleUri == null ? FileLocator.getAsStream((String)DEFAULT_ROLE_MODEL_FILE_NAME) : FileLocator.getAsStream((String)this.parserRoleFileName);
            this.classifier = EngineGetter.getComponent((InputStream)srlRole, (String)this.language, (String)"role");
            InputStream srlModel = this.srlModelUri == null ? FileLocator.getAsStream((String)DEFAULT_SRL_MODEL_FILE_NAME) : FileLocator.getAsStream((String)this.parserModelFileName);
            this.srlabeler = EngineGetter.getComponent((InputStream)srlModel, (String)this.language, (String)"srl");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            int i;
            ArrayList<BaseToken> printableTokens = new ArrayList<BaseToken>();
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence)) {
                if (token instanceof NewlineToken) continue;
                printableTokens.add(token);
            }
            DEPTree tree = new DEPTree();
            HashMap<ConllDependencyNode, Integer> depNodeToID = new HashMap<ConllDependencyNode, Integer>();
            int nodeId = 1;
            for (ConllDependencyNode depNode : JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)sentence)) {
                if (depNode.getHead() == null) {
                    depNodeToID.put(depNode, 0);
                    continue;
                }
                depNodeToID.put(depNode, nodeId);
                ++nodeId;
            }
            int[] headIDs = new int[printableTokens.size()];
            String[] deprels = new String[printableTokens.size()];
            int idIter = 0;
            for (i = 0; i < printableTokens.size(); ++i) {
                Integer headIdIndex;
                BaseToken token = (BaseToken)printableTokens.get(i);
                if (token instanceof NewlineToken) continue;
                List casDepNodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)token);
                ConllDependencyNode casDepNode = (ConllDependencyNode)casDepNodes.get(0);
                if (casDepNode.getId() == 0) {
                    casDepNode = (ConllDependencyNode)casDepNodes.get(1);
                }
                deprels[i] = casDepNode.getDeprel();
                ConllDependencyNode head = casDepNode.getHead();
                Integer n = headIdIndex = head == null ? Integer.valueOf(0) : (Integer)depNodeToID.get(head);
                if (headIdIndex != null) {
                    headIDs[i] = headIdIndex;
                } else {
                    this.logger.error((Object)("No dependency node for index " + head + ".  Map size is " + depNodeToID.size() + "\nSetting head ID to 0"));
                    headIDs[i] = 0;
                }
                int id = idIter + 1;
                String form = casDepNode.getForm();
                String pos = casDepNode.getPostag();
                String lemma = casDepNode.getLemma();
                DEPNode node = new DEPNode(id, form, lemma, pos, new DEPFeat());
                tree.add((Object)node);
                ++idIter;
            }
            for (i = 1; i < tree.size(); ++i) {
                DEPNode node = tree.get(i);
                DEPNode head = tree.get(headIDs[i - 1]);
                String label = deprels[i - 1];
                node.setHead(head, label);
            }
            tree.initSHeads();
            this.identifier.process(tree);
            this.classifier.process(tree);
            this.srlabeler.process(tree);
            this.extractSRLInfo(jCas, printableTokens, tree);
        }
    }

    private void extractSRLInfo(JCas jCas, List<BaseToken> tokens, DEPTree tree) {
        BaseToken token;
        DEPNode parserNode;
        int i;
        HashMap<DEPNode, Predicate> headIdToPredicate = new HashMap<DEPNode, Predicate>();
        HashMap predicateArguments = new HashMap();
        for (i = 1; i < tree.size(); ++i) {
            parserNode = tree.get(i);
            token = tokens.get(i - 1);
            String rolesetId = parserNode.getFeat("pb");
            if (rolesetId == null || headIdToPredicate.containsKey(parserNode)) continue;
            Predicate pred = this.createPredicate(jCas, rolesetId, token);
            headIdToPredicate.put(parserNode, pred);
            pred.setRelations((FSList)new EmptyFSList(jCas));
        }
        for (i = 1; i < tree.size(); ++i) {
            parserNode = tree.get(i);
            token = tokens.get(i - 1);
            for (Object head : parserNode.getSHeads()) {
                Predicate predicate = (Predicate)headIdToPredicate.get(head.getNode());
                if (!predicateArguments.containsKey(predicate)) {
                    predicateArguments.put(predicate, new ArrayList());
                }
                List argumentList = (List)predicateArguments.get(predicate);
                SemanticArgument argument = this.createArgument(jCas, (DEPArc)head, token);
                argumentList.add(argument);
            }
        }
        for (Map.Entry entry : predicateArguments.entrySet()) {
            Predicate predicate = (Predicate)entry.getKey();
            ArrayList<SemanticRoleRelation> relations = new ArrayList<SemanticRoleRelation>();
            for (SemanticArgument argument : (List)entry.getValue()) {
                SemanticRoleRelation relation = new SemanticRoleRelation(jCas);
                relation.setArgument(argument);
                relation.setPredicate(predicate);
                relation.setCategory(argument.getLabel());
                relation.addToIndexes();
                relations.add(relation);
                argument.setRelation(relation);
            }
            FSList relationsList = ListFactory.buildList((JCas)jCas, (TOP[])relations.toArray(new TOP[relations.size()]));
            predicate.setRelations(relationsList);
        }
    }

    private Predicate createPredicate(JCas jCas, String rolesetId, BaseToken token) {
        Predicate pred = new Predicate(jCas, token.getBegin(), token.getEnd());
        pred.setFrameSet(rolesetId);
        pred.addToIndexes();
        return pred;
    }

    private SemanticArgument createArgument(JCas jCas, DEPArc head, BaseToken token) {
        SemanticArgument argument = new SemanticArgument(jCas, token.getBegin(), token.getEnd());
        argument.setLabel(head.getLabel());
        argument.addToIndexes();
        return argument;
    }
}

