/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight.model;

import com.google.common.annotations.Beta;
import java.util.HashMap;
import org.cleartk.ml.svmlight.model.Kernel;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.model.TreeKernel;
import org.cleartk.ml.util.featurevector.FeatureVector;

@Beta
public class CompositeKernel {
    private Kernel featureKernel;
    private TreeKernel treeKernel;
    private ComboOperator operator = ComboOperator.SUM;
    private double tkWeight = 1.0;
    private Normalize normalize;
    private HashMap<FeatureVector, Double> normalizer = new HashMap();

    public CompositeKernel(Kernel fk, TreeKernel tk) {
        this(fk, tk, ComboOperator.SUM, 1.0, Normalize.BOTH);
    }

    public CompositeKernel(Kernel fk, TreeKernel tk, ComboOperator op) {
        this(fk, tk, op, 1.0, Normalize.BOTH);
    }

    public CompositeKernel(Kernel fk, TreeKernel tk, ComboOperator op, double tkWeight, Normalize normalize) {
        this.featureKernel = fk;
        this.treeKernel = tk;
        this.operator = op;
        this.tkWeight = tkWeight;
        this.normalize = normalize;
    }

    public double evaluate(TreeFeatureVector fv1, TreeFeatureVector fv2) {
        double fSim = 0.0;
        FeatureVector vec1 = fv1.getFeatures();
        FeatureVector vec2 = fv2.getFeatures();
        if (this.operator != ComboOperator.TREE_ONLY) {
            fSim = this.featureKernel.evaluate(vec1, vec2);
            if (this.normalize == Normalize.BOTH || this.normalize == Normalize.VECTOR) {
                if (!this.normalizer.containsKey(vec1)) {
                    this.normalizer.put(vec1, this.featureKernel.evaluate(vec1, vec1));
                }
                double v1sim = this.normalizer.get(vec1);
                if (!this.normalizer.containsKey(vec2)) {
                    this.normalizer.put(vec2, this.featureKernel.evaluate(vec2, vec2));
                }
                double v2sim = this.normalizer.get(vec2);
                fSim /= Math.sqrt(v1sim * v2sim);
            }
        }
        double tkSim = 0.0;
        if (this.operator != ComboOperator.VECTOR_ONLY) {
            tkSim = this.treeKernel.evaluate(fv1, fv2);
        }
        if (this.operator == ComboOperator.SUM) {
            return fSim + this.tkWeight * tkSim;
        }
        if (this.operator == ComboOperator.PRODUCT) {
            return fSim * tkSim;
        }
        if (this.operator == ComboOperator.TREE_ONLY) {
            return tkSim;
        }
        return fSim;
    }

    public static enum Normalize {
        NEITHER,
        TREE,
        VECTOR,
        BOTH;

    }

    public static enum ComboOperator {
        SUM,
        PRODUCT,
        TREE_ONLY,
        VECTOR_ONLY;

    }
}

