/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.ImputedFeatureEvaluator;
import org.apache.ctakes.ytex.kernel.SimSvcContextHolder;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.metric.ConceptPair;
import org.apache.ctakes.ytex.kernel.metric.ConceptPairSimilarity;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.IntrinsicLCHMetric;
import org.apache.ctakes.ytex.kernel.metric.IntrinsicPathMetric;
import org.apache.ctakes.ytex.kernel.metric.IntrinsicRadaMetric;
import org.apache.ctakes.ytex.kernel.metric.JaccardMetric;
import org.apache.ctakes.ytex.kernel.metric.LCHMetric;
import org.apache.ctakes.ytex.kernel.metric.LCSPath;
import org.apache.ctakes.ytex.kernel.metric.LinMetric;
import org.apache.ctakes.ytex.kernel.metric.PageRankMetric;
import org.apache.ctakes.ytex.kernel.metric.PathMetric;
import org.apache.ctakes.ytex.kernel.metric.RadaMetric;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;
import org.apache.ctakes.ytex.kernel.metric.SimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.SokalSneathMetric;
import org.apache.ctakes.ytex.kernel.metric.WuPalmerMetric;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.apache.ctakes.ytex.kernel.model.FeatureRank;
import org.apache.ctakes.ytex.kernel.pagerank.PageRankService;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ConceptSimilarityServiceImpl
implements ConceptSimilarityService {
    private static final Log log = LogFactory.getLog(ConceptSimilarityServiceImpl.class);
    private CacheManager cacheManager;
    private ConceptGraph cg = null;
    private ClassifierEvaluationDao classifierEvaluationDao;
    private ConceptDao conceptDao;
    private String conceptGraphName;
    private String conceptSetName;
    private String corpusName;
    private Map<String, BitSet> cuiTuiMap;
    private Cache lcsCache;
    private String lcsImputedType = ImputedFeatureEvaluator.MeasureType.INFOGAIN.getName();
    private PageRankService pageRankService;
    private boolean preload = true;
    private Map<String, Double> corpusICMap;
    private Map<ConceptSimilarityService.SimilarityMetricEnum, SimilarityMetric> similarityMetricMap = null;
    private PlatformTransactionManager transactionManager;
    private List<String> tuiList;

    private static String formatPaths(List<LCSPath> lcsPaths) {
        StringBuilder b = new StringBuilder();
        Iterator<LCSPath> lcsPathIter = lcsPaths.iterator();
        while (lcsPathIter.hasNext()) {
            LCSPath lcsPath = lcsPathIter.next();
            String lcs = lcsPath.getLcs();
            b.append(lcs);
            b.append("=");
            b.append(lcsPath.toString());
            if (!lcsPathIter.hasNext()) continue;
            b.append("|");
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"concepts");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"concept pairs or a file containing concept pairs.  To specify pairs on command line, separate concepts by comma, concept pairs by semicolon.  For file, separate concepts by comma or tab, each concept pair on a new line.");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"concepts"));
        OptionBuilder.withArgName((String)"metrics");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)("comma-separated list of metrics.  Valid metrics: " + Arrays.asList(ConceptSimilarityService.SimilarityMetricEnum.values())));
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"metrics"));
        OptionBuilder.withArgName((String)"out");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file to write oputput to.  if not specified, output sent to stdout.");
        options.addOption(OptionBuilder.create((String)"out"));
        OptionBuilder.withArgName((String)"lcs");
        OptionBuilder.withDescription((String)"output lcs and path for each concept pair");
        options.addOption(OptionBuilder.create((String)"lcs"));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            String concepts = line.getOptionValue("concepts");
            String metrics = line.getOptionValue("metrics");
            String out = line.getOptionValue("out");
            boolean lcs = line.hasOption("lcs");
            PrintStream os = null;
            try {
                os = out != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(out))) : System.out;
                List<ConceptPair> conceptPairs = ConceptSimilarityServiceImpl.parseConcepts(concepts);
                List<ConceptSimilarityService.SimilarityMetricEnum> metricList = ConceptSimilarityServiceImpl.parseMetrics(metrics);
                ConceptSimilarityService simSvc = (ConceptSimilarityService)SimSvcContextHolder.getApplicationContext().getBean(ConceptSimilarityService.class);
                ArrayList<SimilarityInfo> simInfos = lcs ? new ArrayList<SimilarityInfo>(conceptPairs.size()) : null;
                List<ConceptPairSimilarity> conceptSimMap = simSvc.similarity(conceptPairs, metricList, null, lcs);
                ConceptSimilarityServiceImpl.printSimilarities(conceptPairs, conceptSimMap, metricList, simInfos, lcs, os);
            }
            finally {
                if (out != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + ConceptSimilarityServiceImpl.class.getName() + " get concept similiarity", options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ConceptPair> parseConcepts(String concepts) throws IOException {
        try (BufferedReader r = null;){
            ArrayList<ConceptPair> conceptPairs = new ArrayList<ConceptPair>();
            File f = new File(concepts);
            r = f.exists() ? new BufferedReader(new FileReader(f)) : new BufferedReader(new StringReader(concepts));
            String line = null;
            while ((line = r.readLine()) != null) {
                String[] lines;
                for (String subline : lines = line.split(";")) {
                    String[] pair = subline.split(",|\\t");
                    if (pair.length != 2) {
                        System.err.println("cannot parse concept pair: " + subline);
                        continue;
                    }
                    conceptPairs.add(new ConceptPair(pair[0], pair[1]));
                }
            }
            ArrayList<ConceptPair> arrayList = conceptPairs;
            return arrayList;
        }
    }

    private static List<ConceptSimilarityService.SimilarityMetricEnum> parseMetrics(String metrics) {
        String[] ms = metrics.split(",");
        ArrayList<ConceptSimilarityService.SimilarityMetricEnum> metricSet = new ArrayList<ConceptSimilarityService.SimilarityMetricEnum>();
        for (String metric : ms) {
            ConceptSimilarityService.SimilarityMetricEnum m = ConceptSimilarityService.SimilarityMetricEnum.valueOf(metric);
            if (m == null) {
                System.err.println("invalid metric: " + ms);
                continue;
            }
            metricSet.add(m);
        }
        return metricSet;
    }

    private static void printSimilarities(List<ConceptPair> conceptPairs, List<ConceptPairSimilarity> conceptSimList, List<ConceptSimilarityService.SimilarityMetricEnum> metricList, List<SimilarityInfo> simInfos, boolean lcs, PrintStream os) {
        os.print("Concept 1\tConcept 2");
        for (ConceptSimilarityService.SimilarityMetricEnum metric : metricList) {
            os.print("\t");
            os.print((Object)metric);
        }
        if (lcs) {
            os.print("\tlcs(s)\tcorpus lcs\tintrinsic lcs\tpaths");
        }
        os.println();
        for (ConceptPairSimilarity csim : conceptSimList) {
            ConceptPair p = csim.getConceptPair();
            os.print(p.getConcept1());
            os.print("\t");
            os.print(p.getConcept2());
            for (Double sim : csim.getSimilarities()) {
                os.print("\t");
                if (sim != null) {
                    os.print(String.format("%6f", sim));
                    continue;
                }
                os.print(0.0);
            }
            if (lcs) {
                SimilarityInfo simInfo = csim.getSimilarityInfo();
                os.print("\t");
                Iterator<String> lcsIter = simInfo.getLcses().iterator();
                while (lcsIter.hasNext()) {
                    os.print(lcsIter.next());
                    if (!lcsIter.hasNext()) continue;
                    os.print('|');
                }
                os.print("\t");
                os.print(simInfo.getCorpusLcs() == null ? "" : simInfo.getCorpusLcs());
                os.print("\t");
                os.print(simInfo.getIntrinsicLcs() == null ? "" : simInfo.getIntrinsicLcs());
                os.print("\t");
                os.print(ConceptSimilarityServiceImpl.formatPaths(simInfo.getLcsPaths()));
            }
            os.println();
        }
    }

    private void addCuiTuiToMap(Map<String, Set<String>> cuiTuiMap, Map<String, String> tuiMap, String cui, String tui) {
        if (tuiMap.containsKey(tui)) {
            tui = tuiMap.get(tui);
        } else {
            tuiMap.put(tui, tui);
        }
        Set<String> tuis = cuiTuiMap.get(cui);
        if (tuis == null) {
            tuis = new HashSet<String>();
            cuiTuiMap.put(cui, tuis);
        }
        tuis.add(tui);
    }

    @Override
    public Object[] getBestLCS(Set<String> lcses, boolean intrinsicIC, Map<String, Double> conceptFilter) {
        HashMap<String, Double> lcsICMap = new HashMap<String, Double>(lcses.size());
        for (String lcs : lcses) {
            lcsICMap.put(lcs, this.getIC(lcs, intrinsicIC));
        }
        if (conceptFilter != null) {
            double currentBest = -1.0;
            HashSet<String> bestLcses = new HashSet<String>();
            for (String lcs : lcses) {
                if (!conceptFilter.containsKey(lcs)) continue;
                double lcsEval = conceptFilter.get(lcs);
                if (currentBest == -1.0 || lcsEval > currentBest) {
                    bestLcses.clear();
                    bestLcses.add(lcs);
                    currentBest = lcsEval;
                    continue;
                }
                if (currentBest != lcsEval) continue;
                bestLcses.add(lcs);
            }
            if (currentBest < 0.0) {
                currentBest = 0.0;
            }
            if (bestLcses.size() > 0) {
                return this.getBestLCS(bestLcses, lcsICMap);
            }
            return null;
        }
        return this.getBestLCS(lcses, lcsICMap);
    }

    public Object[] getBestLCS(Set<String> lcses, Map<String, Double> icMap) {
        double ic = -1.0;
        String bestLCS = null;
        for (String lcs : lcses) {
            Double ictmp = icMap.get(lcs);
            if (ictmp == null || !(ic < ictmp)) continue;
            ic = ictmp;
            bestLCS = lcs;
        }
        if (ic < 0.0) {
            ic = 0.0;
        }
        return new Object[]{bestLCS, ic};
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public ConceptDao getConceptDao() {
        return this.conceptDao;
    }

    @Override
    public ConceptGraph getConceptGraph() {
        return this.cg;
    }

    @Override
    public String getConceptGraphName() {
        return this.conceptGraphName;
    }

    public String getConceptSetName() {
        return this.conceptSetName;
    }

    public String getCorpusName() {
        return this.corpusName;
    }

    @Override
    public Map<String, BitSet> getCuiTuiMap() {
        return this.cuiTuiMap;
    }

    @Override
    public int getDepth(String concept) {
        ConcRel cr = this.cg.getConceptMap().get(concept);
        if (cr != null) {
            return cr.getDepth();
        }
        return 0;
    }

    @Override
    public double getIC(String concept, boolean intrinsicICMap) {
        double ic = 0.0;
        if (intrinsicICMap) {
            ConcRel cr = this.cg.getConceptMap().get(concept);
            if (cr != null) {
                ic = cr.getIntrinsicInfoContent();
            }
        } else {
            Double icC = null;
            if (this.isPreload()) {
                icC = this.corpusICMap.get(concept);
            } else {
                Map<String, FeatureRank> frMap = this.getICOnDemand(new HashSet<String>(Arrays.asList(concept)), false);
                if (frMap.containsKey(concept)) {
                    return frMap.get(concept).getEvaluation();
                }
            }
            if (icC != null) {
                ic = icC;
            }
        }
        return ic;
    }

    private Map<String, FeatureRank> getICOnDemand(Set<String> lcses, boolean intrinsicIC) {
        if (lcses == null || lcses.isEmpty()) {
            return new HashMap<String, FeatureRank>(0);
        }
        Map<String, FeatureRank> lcsICMap = this.classifierEvaluationDao.getFeatureRanks(lcses, intrinsicIC ? null : this.corpusName, intrinsicIC ? null : this.conceptSetName, null, intrinsicIC ? "intrinsic-infocontent" : "infocontent", null, 0.0, this.getConceptGraphName());
        return lcsICMap;
    }

    @Override
    public int getLCS(String concept1, String concept2, Set<String> lcses, List<LCSPath> lcsPaths) {
        int lcsDist = 0;
        ConcRel cr1 = this.getConceptGraph().getConceptMap().get(concept1);
        ConcRel cr2 = this.getConceptGraph().getConceptMap().get(concept2);
        if (cr1 != null && cr2 != null) {
            lcses.clear();
            if (lcsPaths == null) {
                lcsDist = this.getLCSFromCache(cr1, cr2, lcses);
            } else {
                lcsPaths.clear();
                lcsDist = this.lcs(concept1, concept2, lcsPaths);
                for (LCSPath lcsPath : lcsPaths) {
                    lcses.add(lcsPath.getLcs());
                }
            }
        } else if (log.isDebugEnabled()) {
            if (cr1 == null) {
                log.debug((Object)("could not find concept:" + concept1));
            }
            if (cr2 == null) {
                log.debug((Object)("could not find concept:" + concept2));
            }
        }
        return lcsDist;
    }

    public Cache getLcsCache() {
        return this.lcsCache;
    }

    private int getLCSFromCache(ConcRel cr1, ConcRel cr2, Set<String> lcses) {
        Element e;
        StringBuilder cacheKeyBuilder = new StringBuilder(this.conceptGraphName);
        cacheKeyBuilder.append(cr1.getConceptID().compareTo(cr2.getConceptID()) < 0 ? cr1.getConceptID() : cr2.getConceptID());
        cacheKeyBuilder.append(cr1.getConceptID().compareTo(cr2.getConceptID()) >= 0 ? cr2.getConceptID() : cr1.getConceptID());
        String cacheKey = cacheKeyBuilder.toString();
        Element element = e = this.lcsCache != null ? this.lcsCache.get((Serializable)((Object)cacheKey)) : null;
        if (e != null) {
            if (e.getObjectValue() != null) {
                Object[] val = (Object[])e.getObjectValue();
                lcses.addAll((Set)val[1]);
                return (Integer)val[0];
            }
            return -1;
        }
        Object[] val = null;
        HashSet<ConcRel> lcsCRSet = new HashSet<ConcRel>(2);
        int dist = ConcRel.getLeastCommonConcept(cr1, cr2, lcsCRSet, null);
        if (dist >= 0) {
            val = new Object[2];
            val[0] = dist;
            for (ConcRel cr : lcsCRSet) {
                lcses.add(cr.getConceptID());
            }
            val[1] = lcses;
        }
        if (this.lcsCache != null) {
            e = new Element((Serializable)((Object)cacheKey), (Serializable)val);
            this.lcsCache.put(e);
        }
        return dist;
    }

    public String getLcsImputedType() {
        return this.lcsImputedType;
    }

    public PageRankService getPageRankService() {
        return this.pageRankService;
    }

    public Map<ConceptSimilarityService.SimilarityMetricEnum, SimilarityMetric> getSimilarityMetricMap() {
        return this.similarityMetricMap;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public List<String> getTuiList() {
        return this.tuiList;
    }

    public void init() {
        log.info((Object)("begin initialization for concept graph: " + this.conceptGraphName));
        this.cg = this.conceptDao.getConceptGraph(this.conceptGraphName);
        if (this.cg == null) {
            log.warn((Object)("concept graph null, name: " + this.conceptGraphName));
        } else {
            this.initSimilarityMetricMap();
            if (this.isPreload()) {
                try {
                    TransactionTemplate t = new TransactionTemplate(this.transactionManager);
                    t.setPropagationBehavior(3);
                    t.execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction(TransactionStatus arg0) {
                            ConceptSimilarityServiceImpl.this.initInfoContent();
                            ConceptSimilarityServiceImpl.this.initCuiTuiMapFromCorpus();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    log.info((Object)("could not initialize cui-tui map: " + e.getMessage() + ".  This is expected if you do not have umls installed in your db."));
                }
            }
        }
        log.info((Object)("end initialization for concept graph: " + this.conceptGraphName));
    }

    public void initCuiTuiMapFromCorpus() {
        TreeMap<String, String> tuiMap = new TreeMap<String, String>();
        HashMap<String, Set<String>> tmpTuiCuiMap = new HashMap<String, Set<String>>();
        List<Object[]> listCuiTui = this.classifierEvaluationDao.getCorpusCuiTuis(this.getCorpusName(), this.getConceptGraphName(), this.getConceptSetName());
        for (Object[] cuiTui : listCuiTui) {
            String cui = (String)cuiTui[0];
            String tui = (String)cuiTui[1];
            this.addCuiTuiToMap(tmpTuiCuiMap, tuiMap, cui, tui);
        }
        TreeMap<String, Integer> mapTuiIndex = new TreeMap<String, Integer>();
        ArrayList<String> tmpTuiList = new ArrayList<String>(tuiMap.size());
        int index = 0;
        for (String tui : tuiMap.keySet()) {
            mapTuiIndex.put(tui, index++);
            tmpTuiList.add(tui);
        }
        this.tuiList = Collections.unmodifiableList(tmpTuiList);
        ImmutableMap.Builder cuiTuiBitsetMapBuilder = new ImmutableMap.Builder();
        for (Map.Entry cuiTuiMapEntry : tmpTuiCuiMap.entrySet()) {
            cuiTuiBitsetMapBuilder.put(cuiTuiMapEntry.getKey(), (Object)this.tuiListToBitset((Set)cuiTuiMapEntry.getValue(), mapTuiIndex));
        }
        this.cuiTuiMap = cuiTuiBitsetMapBuilder.build();
    }

    private void initInfoContent() {
        log.info((Object)("loading corpus infocontent for corpusName=" + this.corpusName + ", conceptGraphName=" + this.conceptGraphName + ", conceptSetName=" + this.conceptSetName));
        Map<String, Double> corpusICMap = this.classifierEvaluationDao.getInfoContent(this.corpusName, this.conceptGraphName, this.conceptSetName);
        if (corpusICMap == null || corpusICMap.isEmpty()) {
            log.warn((Object)"IC not found");
        }
        ImmutableMap.Builder mb = new ImmutableMap.Builder();
        for (Map.Entry<String, Double> corpusICEntry : corpusICMap.entrySet()) {
            ConcRel cr = this.cg.getConceptMap().get(corpusICEntry.getKey());
            if (cr == null) continue;
            mb.put((Object)cr.getConceptID(), (Object)corpusICEntry.getValue());
        }
        this.corpusICMap = mb.build();
    }

    private void initSimilarityMetricMap() {
        log.info((Object)"initializing similarity measures");
        double maxIC = this.cg.getIntrinsicICMax();
        short maxDepth = this.cg.getDepthMax();
        this.similarityMetricMap = new HashMap<ConceptSimilarityService.SimilarityMetricEnum, SimilarityMetric>(ConceptSimilarityService.SimilarityMetricEnum.values().length);
        if (maxDepth > 0) {
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.LCH, new LCHMetric(this, Integer.valueOf(maxDepth)));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.LIN, new LinMetric(this, false));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.INTRINSIC_LIN, new LinMetric(this, true));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.INTRINSIC_LCH, new IntrinsicLCHMetric(this, maxIC));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.PATH, new PathMetric(this));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.INTRINSIC_PATH, new IntrinsicPathMetric(this, maxIC));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.RADA, new RadaMetric(this, Integer.valueOf(maxDepth)));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.INTRINSIC_RADA, new IntrinsicRadaMetric(this, maxIC));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.SOKAL, new SokalSneathMetric(this));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.JACCARD, new JaccardMetric(this));
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.WUPALMER, new WuPalmerMetric(this));
        } else {
            this.similarityMetricMap.put(ConceptSimilarityService.SimilarityMetricEnum.PAGERANK, new PageRankMetric(this, this.getPageRankService()));
        }
    }

    public boolean isPreload() {
        return this.preload;
    }

    @Override
    public int lcs(String concept1, String concept2, List<LCSPath> lcsPaths) {
        ConcRel cr1 = this.cg.getConceptMap().get(concept1);
        ConcRel cr2 = this.cg.getConceptMap().get(concept2);
        int dist = -1;
        if (cr1 != null && cr2 != null) {
            HashSet<ConcRel> crlcses = new HashSet<ConcRel>();
            HashMap<ConcRel, LCSPath> crpaths = new HashMap<ConcRel, LCSPath>();
            dist = ConcRel.getLeastCommonConcept(cr1, cr2, crlcses, crpaths);
            lcsPaths.addAll(crpaths.values());
        }
        return dist;
    }

    @Override
    public double loadConceptFilter(String label, int rankCutoff, Map<String, Double> conceptFilter) {
        List<FeatureRank> imputedConcepts = this.classifierEvaluationDao.getImputedFeaturesByPropagatedCutoff(this.corpusName, this.conceptSetName, label, this.lcsImputedType + "-imputed", this.conceptGraphName, this.lcsImputedType + "-propagated", rankCutoff);
        double minEval = 1.0;
        for (FeatureRank r : imputedConcepts) {
            conceptFilter.put(r.getFeatureName(), r.getEvaluation());
            if (!(minEval >= r.getEvaluation())) continue;
            minEval = r.getEvaluation();
        }
        return minEval;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setConceptDao(ConceptDao conceptDao) {
        this.conceptDao = conceptDao;
    }

    public void setConceptGraphName(String conceptGraphName) {
        this.conceptGraphName = conceptGraphName;
    }

    public void setConceptSetName(String conceptSetName) {
        this.conceptSetName = conceptSetName;
    }

    public void setCorpusName(String corpusName) {
        this.corpusName = corpusName;
    }

    public void setLcsCache(Cache lcsCache) {
        this.lcsCache = lcsCache;
    }

    public void setLcsImputedType(String lcsImputedType) {
        this.lcsImputedType = lcsImputedType;
    }

    public void setPageRankService(PageRankService pageRankService) {
        this.pageRankService = pageRankService;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public void setSimilarityMetricMap(Map<ConceptSimilarityService.SimilarityMetricEnum, SimilarityMetric> similarityMetricMap) {
        this.similarityMetricMap = similarityMetricMap;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public List<ConceptPairSimilarity> similarity(List<ConceptPair> conceptPairs, List<ConceptSimilarityService.SimilarityMetricEnum> metrics, Map<String, Double> conceptFilter, boolean lcs) {
        ArrayList<ConceptPairSimilarity> conceptSimMap = new ArrayList<ConceptPairSimilarity>(conceptPairs.size());
        for (ConceptPair conceptPair : conceptPairs) {
            conceptSimMap.add(this.similarity(metrics, conceptPair.getConcept1(), conceptPair.getConcept2(), conceptFilter, lcs));
        }
        return conceptSimMap;
    }

    @Override
    public ConceptPairSimilarity similarity(List<ConceptSimilarityService.SimilarityMetricEnum> metrics, String concept1, String concept2, Map<String, Double> conceptFilter, boolean lcs) {
        SimilarityInfo simInfo = new SimilarityInfo();
        if (lcs) {
            simInfo.setLcsPaths(new ArrayList<LCSPath>(1));
        }
        ArrayList<Double> similarities = new ArrayList<Double>(metrics.size());
        if (this.cg != null) {
            for (ConceptSimilarityService.SimilarityMetricEnum metric : metrics) {
                double sim = this.similarityMetricMap.get((Object)metric).similarity(concept1, concept2, conceptFilter, simInfo);
                similarities.add(sim);
            }
        }
        ConceptPairSimilarity csim = new ConceptPairSimilarity();
        csim.setConceptPair(new ConceptPair(concept1, concept2));
        csim.setSimilarities(similarities);
        csim.setSimilarityInfo(simInfo);
        return csim;
    }

    private BitSet tuiListToBitset(Set<String> tuis, SortedMap<String, Integer> mapTuiIndex) {
        BitSet bs = new BitSet(mapTuiIndex.size());
        for (String tui : tuis) {
            bs.set((Integer)mapTuiIndex.get(tui));
        }
        return bs;
    }
}

