/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.FileUtil;

public class ClassifierEvalUtil {
    private static final Log log = LogFactory.getLog(ClassifierEvalUtil.class);
    Properties props;

    public ClassifierEvalUtil(String propFile) throws IOException {
        this.props = propFile != null ? FileUtil.loadProperties(propFile, true) : System.getProperties();
    }

    public static void main(String[] args) throws IOException {
        String propFile = null;
        if (args.length > 0) {
            propFile = args[0];
        }
        ClassifierEvalUtil ceUtil = new ClassifierEvalUtil(propFile);
        ceUtil.generateEvalFiles();
    }

    private void generateEvalFiles() throws IOException {
        String algo = this.props.getProperty("kernel.algo");
        if ("semil".equalsIgnoreCase(algo)) {
            this.generateSemilEvalParams();
        } else if ("svmlight".equalsIgnoreCase(algo) || "libsvm".equalsIgnoreCase(algo)) {
            this.generateSvmEvalParams(algo.toLowerCase());
        } else if ("svmlin".equalsIgnoreCase(algo)) {
            this.generateSvmLinParams(algo.toLowerCase());
        }
    }

    private void generateSvmLinParams(String lowerCase) throws IOException {
        Properties weightProps;
        File kernelDataDir = new File(this.props.getProperty("kernel.data", "."));
        String weightPropsFile = this.props.getProperty("kernel.svmlin.classweights", kernelDataDir + "/classWeights.properties");
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading weights from " + weightPropsFile));
        }
        if ((weightProps = FileUtil.loadProperties(weightPropsFile, false)) == null) {
            log.warn((Object)("could not load weights from file: " + weightPropsFile));
        }
        Properties props = new Properties();
        File[] labelFiles = kernelDataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("code.properties");
            }
        });
        if (labelFiles != null && labelFiles.length > 0) {
            for (File labelFile : labelFiles) {
                this.populateSvmlinParameters(labelFile, kernelDataDir, weightProps, props);
            }
        }
        this.writeProps(kernelDataDir + "/parameters.properties", props);
    }

    private String getSvmlinDataFileForLabel(File labelFile, File kernelDataDir) {
        String labelFileName = labelFile.getName();
        String label = FileUtil.parseLabelFromFileName(labelFileName);
        Integer run = FileUtil.parseRunFromFileName(labelFileName);
        Integer fold = FileUtil.parseFoldFromFileName(labelFileName);
        File dataFile = null;
        if (fold != null && fold != 0) {
            dataFile = new File(FileUtil.getScopedFileName(kernelDataDir.getPath(), label, run, fold, "data.txt"));
        }
        if (!(dataFile != null && dataFile.exists() || label == null || label.length() <= 0)) {
            dataFile = new File(FileUtil.getScopedFileName(kernelDataDir.getPath(), label, null, null, "data.txt"));
        }
        if (dataFile == null || !dataFile.exists()) {
            dataFile = new File(FileUtil.getScopedFileName(kernelDataDir.getPath(), null, null, null, "data.txt"));
        }
        if (dataFile != null && dataFile.exists()) {
            return dataFile.getName();
        }
        log.warn((Object)("no data files match label file: " + labelFile));
        return null;
    }

    private void populateSvmlinParameters(File codeFile, File kernelDataDir, Properties weightProps, Properties paramProps) throws IOException {
        String codeFileBasename = codeFile.getName();
        codeFileBasename = codeFileBasename.substring(0, codeFileBasename.length() - ".properties".length());
        String dataFile = this.getSvmlinDataFileForLabel(codeFile, kernelDataDir);
        if (dataFile != null) {
            paramProps.setProperty(codeFileBasename + ".dataFile", dataFile);
            List<String> algos = Arrays.asList(this.addOptionPrefix(this.props.getProperty("cv.svmlin.algo").split(","), "-A "));
            List<String> lambdaU = Arrays.asList(this.addOptionPrefix(this.props.getProperty("cv.svmlin.lambdaW").split(","), "-W "));
            List<String> lambdaW = Arrays.asList(this.addOptionPrefix(this.props.getProperty("cv.svmlin.lambdaU").split(","), "-U "));
            List<String> evalLines = this.parameterGrid(algos, lambdaU, lambdaW);
            paramProps.setProperty(codeFileBasename + ".kernel.evalLines", this.listToString(evalLines));
            if (weightProps != null) {
                Properties codeProps = FileUtil.loadProperties(codeFile.getAbsolutePath(), false);
                for (String labelfile : codeProps.getProperty("codes", "").split(",")) {
                    String className = codeProps.getProperty(labelfile + ".className");
                    String label = FileUtil.parseLabelFromFileName(labelfile);
                    String key = label != null && label.length() > 0 ? "label" + label + "_" : "";
                    String posClassFrac = weightProps.getProperty(key = key + "class" + className);
                    if (posClassFrac == null) continue;
                    paramProps.put(labelfile + ".param.R", posClassFrac);
                }
            }
        }
    }

    private void generateSvmEvalParams(String svmType) throws IOException {
        File kernelDataDir = new File(this.props.getProperty("kernel.data", "."));
        File[] trainFiles = kernelDataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("train_data.txt");
            }
        });
        Properties params = new Properties();
        if (trainFiles != null && trainFiles.length > 0) {
            for (File trainFile : trainFiles) {
                this.writeSvmEvalFile(params, trainFile, kernelDataDir, svmType);
            }
        }
        this.writeProps(kernelDataDir + "/parameters.properties", params);
    }

    private void writeSvmEvalFile(Properties params, File trainFile, File kernelDataDir, String svmType) throws IOException {
        ArrayList<String> evalLines = new ArrayList<String>();
        List<String> weightParams = this.getWeightParams(trainFile, svmType);
        List<String> kernels = Arrays.asList(this.props.getProperty("kernel.types").split(","));
        List<String> costs = Arrays.asList(this.addOptionPrefix(this.props.getProperty("cv.costs").split(","), "-c "));
        List<String> libsvmEval = Arrays.asList(this.props.getProperty("cv." + svmType + ".train.line", "").split(","));
        for (String kernel : kernels) {
            List<String> kernelOpts = Arrays.asList("-t " + kernel);
            if ("0".equals(kernel) || "4".equals(kernel)) {
                evalLines.addAll(this.parameterGrid(libsvmEval, kernelOpts, costs, weightParams));
                continue;
            }
            if ("1".equals(kernel)) {
                evalLines.addAll(this.parameterGrid(libsvmEval, kernelOpts, costs, weightParams, Arrays.asList(this.addOptionPrefix(this.props.getProperty("cv.poly.degrees").split(","), "-d "))));
                continue;
            }
            if (!"2".equals(kernel) && !"3".equals(kernel)) continue;
            evalLines.addAll(this.parameterGrid(libsvmEval, kernelOpts, costs, weightParams, Arrays.asList(this.addOptionPrefix(this.props.getProperty("cv.rbf.gammas").split(","), "-g "))));
        }
        if (evalLines.size() > 0) {
            String basename = trainFile.getName().substring(0, trainFile.getName().length() - 4);
            params.put(basename + ".kernel.evalLines", this.listToString(evalLines));
        }
    }

    private List<String> getWeightParams(File trainFile, String svmType) throws IOException {
        if ("libsvm".equals(svmType)) {
            String weights;
            Properties tmp;
            String label = FileUtil.parseLabelFromFileName(trainFile.getName());
            label = label != null && label.length() > 0 ? label : "0";
            Properties weightProps = new Properties();
            weightProps.putAll((Map<?, ?>)this.props);
            if (this.props.getProperty("kernel.classweights") != null && (tmp = FileUtil.loadProperties(this.props.getProperty("kernel.classweights"), false)) != null) {
                weightProps.putAll((Map<?, ?>)tmp);
            }
            if ((weights = weightProps.getProperty("kernel.weight." + label)) != null && weights.length() > 0) {
                return Arrays.asList(weights.split(","));
            }
        }
        return new ArrayList<String>(0);
    }

    private void generateSemilEvalParams() throws IOException {
        File kernelDataDir = new File(this.props.getProperty("kernel.data", "."));
        List<String> evalLines = this.generateSemilEvalLines();
        File[] labelFiles = kernelDataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("label.txt");
            }
        });
        if (labelFiles != null && labelFiles.length > 0) {
            for (File labelFile : labelFiles) {
                List<String> distFiles = this.getSemilDistFilesForLabel(labelFile, kernelDataDir);
                if (distFiles == null) continue;
                this.writeSemilEvalFile(distFiles, evalLines, labelFile);
            }
        }
    }

    private String listToString(List<String> listStr) {
        StringBuilder b = new StringBuilder();
        boolean bfirst = true;
        for (String str : listStr) {
            if (!bfirst) {
                b.append(",");
            }
            b.append(str);
            bfirst = false;
        }
        return b.toString();
    }

    private void writeSemilEvalFile(List<String> distFiles, List<String> evalLines, File labelFile) throws IOException {
        String labelFileName = labelFile.getPath();
        String evalFileName = labelFileName.substring(0, labelFileName.length() - 3) + "properties";
        Properties props = new Properties();
        props.setProperty("kernel.distFiles", this.listToString(distFiles));
        props.setProperty("kernel.evalLines", this.listToString(evalLines));
        this.writeProps(evalFileName, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProps(String evalFileName, Properties evalProps) throws IOException {
        File evalFile;
        if ("no".equalsIgnoreCase(this.props.getProperty("kernel.overwriteEvalFile", "yes")) && (evalFile = new File(evalFileName)).exists()) {
            log.warn((Object)("skipping because eval file exists: " + evalFileName));
            return;
        }
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new FileWriter(evalFileName));
            evalProps.store(w, null);
        }
    }

    private List<String> generateSemilEvalLines() {
        String gammas = this.props.getProperty("cv.rbf.gammas");
        List<String> gammaOpts = null;
        if (gammas != null && gammas.length() > 0) {
            gammaOpts = Arrays.asList(this.addOptionPrefix(gammas.split(","), "-g "));
        }
        List<String> methods = Arrays.asList(this.props.getProperty("cv.semil.methods", "").split(","));
        List<String> semil = Arrays.asList(this.props.getProperty("cv.semil.line", "").split(","));
        return this.parameterGrid(semil, gammaOpts, methods);
    }

    private String[] addOptionPrefix(String[] args, String prefix) {
        String[] options = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            options[i] = prefix + args[i];
        }
        return options;
    }

    private List<String> parameterGrid(List<String> lines, Object ... params) {
        ArrayList<String> newLines = new ArrayList<String>();
        List paramList = (List)params[0];
        if (paramList != null && paramList.size() > 0) {
            for (String line : lines) {
                for (String param : paramList) {
                    newLines.add(line + " " + param);
                }
            }
        } else {
            newLines.addAll(lines);
        }
        if (params.length > 1) {
            return this.parameterGrid(newLines, Arrays.copyOfRange(params, 1, params.length));
        }
        return newLines;
    }

    private List<String> getSemilDistFilesForLabel(File labelFile, File kernelDataDir) {
        String filePrefix;
        String labelFileName = labelFile.getName();
        String label = FileUtil.parseLabelFromFileName(labelFileName);
        Integer run = FileUtil.parseRunFromFileName(labelFileName);
        Integer fold = FileUtil.parseFoldFromFileName(labelFileName);
        File[] distFiles = null;
        if (fold != null) {
            filePrefix = FileUtil.getFoldFilePrefix(null, label, run, fold) + "_dist_";
            distFiles = kernelDataDir.listFiles(new FileUtil.PrefixFileFilter(filePrefix));
        }
        if ((distFiles == null || distFiles.length == 0) && label != null) {
            filePrefix = FileUtil.getFoldFilePrefix(null, label, null, null) + "_dist_";
            distFiles = kernelDataDir.listFiles(new FileUtil.PrefixFileFilter(filePrefix));
        }
        if (distFiles == null || distFiles.length == 0) {
            distFiles = kernelDataDir.listFiles(new FileUtil.PrefixFileFilter("dist_"));
        }
        if (distFiles != null && distFiles.length > 0) {
            ArrayList<String> listDistFiles = new ArrayList<String>(distFiles.length);
            for (File distFile : distFiles) {
                listDistFiles.add(distFile.getName());
            }
            return listDistFiles;
        }
        log.warn((Object)("no dist files match label file: " + labelFile));
        return null;
    }
}

