/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.data.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.ctakes.jdl.common.FileUtil;
import org.apache.ctakes.jdl.data.xml.DomUtil;
import org.apache.ctakes.jdl.data.xml.SchemaUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validation {
    private Document document;
    private String srcXml;
    private Validator validator;
    private String error;

    public Validation(Schema schema) {
        this.setSchema(schema);
    }

    public Validation(String srcXsd) {
        this.setSchema(srcXsd);
    }

    public Validation(Schema schema, Document document) {
        this.setSchema(schema);
        this.setDocument(document);
    }

    public Validation(Schema schema, String srcXml) {
        this.setSchema(schema);
        this.setDocument(srcXml);
    }

    public final void setSchema(Schema schema) {
        this.validator = schema.newValidator();
        this.error = null;
    }

    public final void setSchema(String srcXsd) {
        this.setSchema(SchemaUtil.srcToSchema(srcXsd));
    }

    public final void setDocument(Document document) {
        this.document = document;
        this.error = null;
        this.srcXml = null;
    }

    public final void setDocument(String srcXml) {
        DomUtil.srcToDocument(FileUtil.getFile(srcXml).toString());
        this.srcXml = srcXml;
        this.error = null;
        this.document = null;
    }

    public final String getError() {
        return this.error;
    }

    private boolean succeed(Source source) {
        try {
            this.validator.validate(source);
            this.error = null;
            return true;
        }
        catch (SAXException e) {
            this.error = e.getMessage();
        }
        catch (IOException e) {
            this.error = e.getMessage();
        }
        return false;
    }

    private boolean domSucceed() {
        return this.succeed(new DOMSource(this.document));
    }

    private boolean saxSucceed() {
        try {
            return this.succeed(new SAXSource(new InputSource(new FileInputStream(this.srcXml))));
        }
        catch (FileNotFoundException e) {
            this.error = e.getMessage();
            return false;
        }
    }

    public final boolean succeed() {
        return this.document == null ? this.saxSucceed() : this.domSucceed();
    }
}

