/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.consumer.AbstractTermConsumer;
import org.apache.ctakes.dictionary.lookup2.consumer.DefaultUmlsConceptCreator;
import org.apache.ctakes.dictionary.lookup2.consumer.UmlsConceptCreator;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.ctakes.dictionary.lookup2.util.CuiCodeUtil;
import org.apache.ctakes.dictionary.lookup2.util.SemanticUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.LabMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public final class DefaultTermConsumer
extends AbstractTermConsumer {
    private final UmlsConceptCreator _umlsConceptCreator;

    public DefaultTermConsumer(UimaContext uimaContext, Properties properties) {
        this(uimaContext, properties, new DefaultUmlsConceptCreator());
    }

    public DefaultTermConsumer(UimaContext uimaContext, Properties properties, UmlsConceptCreator umlsConceptCreator) {
        super(uimaContext, properties);
        this._umlsConceptCreator = umlsConceptCreator;
    }

    @Override
    public void consumeTypeIdHits(JCas jcas, String codingScheme, int cTakesSemantic, CollectionMap<TextSpan, Long, ? extends Collection<Long>> textSpanCuis, CollectionMap<Long, Concept, ? extends Collection<Concept>> cuiConcepts) throws AnalysisEngineProcessException {
        ArrayList<UmlsConcept> umlsConceptList = new ArrayList<UmlsConcept>();
        try {
            for (Map.Entry spanCuis : textSpanCuis) {
                umlsConceptList.clear();
                for (Long cuiCode : (Collection)spanCuis.getValue()) {
                    umlsConceptList.addAll(this.createUmlsConcepts(jcas, codingScheme, cTakesSemantic, cuiCode, cuiConcepts));
                }
                FSArray conceptArr = new FSArray(jcas, umlsConceptList.size());
                int arrIdx = 0;
                for (UmlsConcept umlsConcept : umlsConceptList) {
                    conceptArr.set(arrIdx, (FeatureStructure)umlsConcept);
                    ++arrIdx;
                }
                IdentifiedAnnotation annotation = DefaultTermConsumer.createSemanticAnnotation(jcas, cTakesSemantic);
                annotation.setTypeID(cTakesSemantic);
                annotation.setBegin(((TextSpan)spanCuis.getKey()).getStart());
                annotation.setEnd(((TextSpan)spanCuis.getKey()).getEnd());
                annotation.setDiscoveryTechnique(1);
                annotation.setOntologyConceptArr(conceptArr);
                annotation.addToIndexes();
            }
        }
        catch (CASRuntimeException crtE) {
            throw new AnalysisEngineProcessException((Throwable)crtE);
        }
    }

    private static IdentifiedAnnotation createSemanticAnnotation(JCas jcas, int cTakesSemantic) {
        switch (cTakesSemantic) {
            case 1: {
                return new MedicationMention(jcas);
            }
            case 6: {
                return new AnatomicalSiteMention(jcas);
            }
            case 2: {
                return new DiseaseDisorderMention(jcas);
            }
            case 3: {
                return new SignSymptomMention(jcas);
            }
            case 9: {
                return new LabMention(jcas);
            }
            case 5: {
                return new ProcedureMention(jcas);
            }
        }
        return new EntityMention(jcas);
    }

    private Collection<UmlsConcept> createUmlsConcepts(JCas jcas, String codingScheme, int cTakesSemantic, Long cuiCode, CollectionMap<Long, Concept, ? extends Collection<Concept>> conceptMap) {
        Collection concepts = conceptMap.getCollection((Object)cuiCode);
        if (concepts == null || concepts.isEmpty()) {
            return Collections.singletonList(DefaultTermConsumer.createSimpleUmlsConcept(jcas, codingScheme, CuiCodeUtil.getInstance().getAsCui(cuiCode)));
        }
        HashSet<UmlsConcept> umlsConcepts = new HashSet<UmlsConcept>();
        for (Concept concept : concepts) {
            Collection<Integer> allSemantics = concept.getCtakesSemantics();
            if (!allSemantics.contains(cTakesSemantic)) continue;
            boolean added = false;
            Collection<String> tuis = concept.getCodes("TUI");
            if (!tuis.isEmpty()) {
                for (String tui : tuis) {
                    if (SemanticUtil.getTuiSemanticGroupId(tui) != cTakesSemantic) continue;
                    umlsConcepts.addAll(this._umlsConceptCreator.createUmlsConcepts(jcas, codingScheme, tui, concept));
                    added = true;
                }
            }
            if (added) continue;
            umlsConcepts.addAll(this._umlsConceptCreator.createUmlsConcepts(jcas, codingScheme, null, concept));
        }
        return umlsConcepts;
    }

    private static UmlsConcept createSimpleUmlsConcept(JCas jcas, String codingScheme, String cui) {
        UmlsConcept umlsConcept = new UmlsConcept(jcas);
        umlsConcept.setCodingScheme(codingScheme);
        umlsConcept.setCui(cui);
        return umlsConcept;
    }
}

