/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.PatternSyntaxException;
import jregex.Term;

class Lookbehind
extends Term {
    final boolean isPositive;
    private int prevDistance = -1;

    Lookbehind(int id, boolean isPositive) {
        this.distance = 0;
        this.isPositive = isPositive;
        this.in = this;
        this.out = new Term();
        if (isPositive) {
            this.type = 39;
            this.out.type = 40;
        } else {
            this.type = 41;
            this.out.type = 42;
            this.branchOut = this;
        }
        this.lookaheadId = id;
        this.out.lookaheadId = id;
    }

    protected Term append(Term t) throws PatternSyntaxException {
        this.distance += Lookbehind.length(t);
        return super.append(t);
    }

    protected Term replaceCurrent(Term t) throws PatternSyntaxException {
        this.distance += Lookbehind.length(t) - Lookbehind.length(this.current);
        return super.replaceCurrent(t);
    }

    private static int length(Term t) throws PatternSyntaxException {
        int type = t.type;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 0;
            }
        }
        if (type >= 11 && type <= 31) {
            return 0;
        }
        throw new PatternSyntaxException("variable length element within a lookbehind assertion");
    }

    protected void startNewBranch() throws PatternSyntaxException {
        this.prevDistance = this.distance;
        this.distance = 0;
        super.startNewBranch();
    }

    protected void close() throws PatternSyntaxException {
        int pd = this.prevDistance;
        if (pd >= 0 && this.distance != pd) {
            throw new PatternSyntaxException("non-equal branch lengths within a lookbehind assertion");
        }
        super.close();
    }
}

