/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.utils.struct.MapFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class MarkableUtilities {
    public static Map<Markable, List<IdentifiedAnnotation>> indexCoveringUmlsAnnotations(JCas jCas) {
        HashMap<Markable, List<IdentifiedAnnotation>> map = new HashMap<Markable, List<IdentifiedAnnotation>>();
        Map dep2event = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        for (CollectionTextRelation cluster : JCasUtil.select((JCas)jCas, CollectionTextRelation.class)) {
            ArrayList memberList = new ArrayList(JCasUtil.select((FSList)cluster.getMembers(), Markable.class));
            for (Markable member : memberList) {
                map.put(member, new ArrayList());
                ConllDependencyNode head = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)member);
                for (IdentifiedAnnotation covering : (Collection)dep2event.get(head)) {
                    if (!MarkableUtilities.isUmlsAnnotation(covering) || head != DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)covering)) continue;
                    ((List)map.get(member)).add(covering);
                }
            }
        }
        return map;
    }

    private static boolean isUmlsEvent(IdentifiedAnnotation a) {
        return a instanceof DiseaseDisorderMention || a instanceof SignSymptomMention || a instanceof ProcedureMention || a instanceof MedicationMention;
    }

    private static boolean isUmlsAnnotation(IdentifiedAnnotation a) {
        return MarkableUtilities.isUmlsEvent(a) || a instanceof AnatomicalSiteMention;
    }
}

