/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.utils.struct.MapFactory;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class TokenFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        String s1 = arg1.getCoveredText().toLowerCase();
        String s2 = arg2.getCoveredText().toLowerCase();
        boolean dem1 = TokenFeatureExtractor.isDemonstrative(s1);
        boolean dem2 = TokenFeatureExtractor.isDemonstrative(s2);
        feats.add(new Feature("TOKEN_DEM1", (Object)dem1));
        feats.add(new Feature("TOKEN_DEM2", (Object)dem2));
        feats.add(new Feature("TOKEN_DEF1", (Object)TokenFeatureExtractor.isDefinite(s1)));
        feats.add(new Feature("TOKEN_DEF2", (Object)TokenFeatureExtractor.isDefinite(s2)));
        feats.add(new Feature("TOKEN_NUMAGREE", (Object)(TokenFeatureExtractor.numberSingular(jCas, (Annotation)arg1, s1) == TokenFeatureExtractor.numberSingular(jCas, (Annotation)arg2, s2) ? 1 : 0)));
        String gen1 = TokenFeatureExtractor.getGender(s1);
        String gen2 = TokenFeatureExtractor.getGender(s2);
        feats.add(new Feature("TOKEN_GEN1", (Object)gen1));
        feats.add(new Feature("TOKEN_GEN2", (Object)gen2));
        feats.add(new Feature("TOKEN_GENAGREE", (Object)gen1.equals(gen2)));
        List nextToks = JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (int)1);
        if (nextToks.size() > 0 && nextToks.get(0) instanceof NewlineToken) {
            feats.add(new Feature("IS_HEADER1", (Object)true));
        }
        if ((nextToks = JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)arg2, (int)1)).size() > 0 && nextToks.get(0) instanceof NewlineToken) {
            feats.add(new Feature("IS_HEADER2", (Object)true));
        }
        return feats;
    }

    public static boolean isDemonstrative(String s) {
        return s.startsWith("this") || s.startsWith("that") || s.startsWith("these") || s.startsWith("those");
    }

    public static boolean isDefinite(String s) {
        return s.startsWith("the ");
    }

    public static boolean numberSingular(JCas jcas, Annotation arg, String s1) {
        ConllDependencyNode head = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jcas), (TOP)arg);
        if (head != null && head.getPostag() != null) {
            String pos = head.getPostag();
            if ("NN".equals(pos) || "NNP".equals(pos)) {
                return true;
            }
            if ("NNS".equals(pos) || "NNPS".equals(pos)) {
                return false;
            }
            if (s1.equals("we") || s1.equals("they")) {
                return false;
            }
        }
        return true;
    }

    public static String getGender(String s1) {
        if (s1.equals("he") || s1.equals("his") || s1.equals("him") || s1.startsWith("mr.")) {
            return "MALE";
        }
        if (s1.equals("she") || s1.equals("her") || s1.startsWith("mrs.") || s1.startsWith("ms.")) {
            return "FEMALE";
        }
        return "NEUTER";
    }

    public static String getPerson(String s1) {
        if (s1.equals("i") || s1.equals("my")) {
            return "FIRST";
        }
        if (s1.equals("he") || s1.equals("she") || s1.equals("his") || s1.equals("her") || s1.equals("hers")) {
            return "THIRD";
        }
        if (s1.equals("you") || s1.equals("your")) {
            return "SECOND";
        }
        if (s1.equals("we") || s1.equals("our")) {
            return "FIRST_PLURAL";
        }
        if (s1.equals("they") || s1.equals("their")) {
            return "THIRD_PLURAL";
        }
        return "NONE";
    }

    public static boolean getAnimate(String s1) {
        return s1.equals("i");
    }

    public static boolean isTitle(String s1) {
        return s1.startsWith("dr.") || s1.startsWith("mr.") || s1.startsWith("mrs.") || s1.startsWith("ms.");
    }

    public static boolean isNegated(IdentifiedAnnotation mention) {
        return mention.getPolarity() == -1;
    }

    public static boolean isUncertain(IdentifiedAnnotation mention) {
        return mention.getUncertainty() == 1;
    }

    public static boolean isGeneric(IdentifiedAnnotation mention) {
        return mention.getGeneric();
    }

    public static boolean isPatient(IdentifiedAnnotation mention) {
        return mention.getSubject() == "patient";
    }

    public static boolean isHistory(IdentifiedAnnotation mention) {
        return mention.getHistoryOf() == 1;
    }
}

