/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.coreference.type.DemMarkable;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.type.NEMarkable;
import org.apache.ctakes.coreference.util.FSIteratorToList;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Markable Expander (MiPACQ)", description="Expands Markable text spans to cover a noun phrase.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.MARKABLE, PipeBitInfo.TypeProduct.CHUNK})
public class MipacqMarkableExpander
extends JCasAnnotator_ImplBase {
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        MipacqMarkableExpander.removeHistoryOf(aJCas);
        FSIterator iter = aJCas.getJFSIndexRepository().getAnnotationIndex(Markable.type).iterator();
        MipacqMarkableExpander.expandToNP(aJCas, FSIteratorToList.convert(iter));
        MipacqMarkableExpander.mergeNP(aJCas);
        MipacqMarkableExpander.elevateAdjectives(aJCas);
        iter = aJCas.getJFSIndexRepository().getAnnotationIndex(Markable.type).iterator();
        MipacqMarkableExpander.rmDup(FSIteratorToList.convert(iter));
    }

    private static void removeHistoryOf(JCas jCas) {
        FSIterator iter = jCas.getAnnotationIndex(NEMarkable.type).iterator();
        ArrayList<NEMarkable> rm = new ArrayList<NEMarkable>();
        while (iter.hasNext()) {
            NEMarkable m = (NEMarkable)((Object)iter.next());
            if (!m.getCoveredText().equalsIgnoreCase("history of")) continue;
            rm.add(m);
        }
        for (Annotation annotation : rm) {
            annotation.removeFromIndexes();
        }
    }

    private static void expandToNP(JCas aJCas, LinkedList<Annotation> markables) {
        for (Annotation m : markables) {
            TreebankNode node = MarkableTreeUtils.markableNode(aJCas, m.getBegin(), m.getEnd());
            if (node == null) continue;
            while (!node.getNodeType().equals("NP") && !node.getNodeType().equals("NML") && (node = node.getParent()) != null) {
            }
            if (node == null || node.getChildren().size() == 3 && node.getChildren(1).getNodeType().equals("CC") || node.getEnd() - 1 > m.getEnd()) continue;
            String s = node.getCoveredText().toLowerCase();
            if (s.startsWith("his ") || s.startsWith("her ") || s.startsWith("its ")) {
                m.setBegin(node.getBegin() + 4);
                continue;
            }
            if (s.startsWith("their ")) {
                m.setBegin(node.getBegin() + 6);
                continue;
            }
            if (s.matches("^\\s*$")) continue;
            m.setBegin(node.getBegin());
        }
    }

    private static void mergeNP(JCas jcas) {
        Map<Integer, Object> innerMap = null;
        FSIterator nodeIter = jcas.getAnnotationIndex(TreebankNode.type).iterator();
        HashMap<Integer, HashMap<Integer, TreebankNode>> npMap = new HashMap<Integer, HashMap<Integer, TreebankNode>>();
        while (nodeIter.hasNext()) {
            TreebankNode node = (TreebankNode)nodeIter.next();
            if (!node.getNodeType().equals("NP")) continue;
            innerMap = (HashMap<Integer, TreebankNode>)npMap.get(node.getBegin());
            if (innerMap == null) {
                innerMap = new HashMap<Integer, TreebankNode>();
            }
            innerMap.put(node.getEnd(), node);
            npMap.put(node.getBegin(), (HashMap<Integer, TreebankNode>)innerMap);
        }
        for (Markable nem : jcas.getAnnotationIndex(Markable.type)) {
            TreebankNode node;
            TreebankNode parent;
            innerMap = (Map)npMap.get(nem.getBegin());
            if (innerMap == null || !innerMap.containsKey(nem.getEnd()) || (parent = (node = (TreebankNode)innerMap.get(nem.getEnd())).getParent()).getChildren().size() != 2 || parent.getChildren(0) != node || !parent.getNodeType().equals("NP") || !parent.getChildren(1).getNodeType().equals("PP")) continue;
            nem.setEnd(parent.getEnd());
        }
    }

    private static void elevateAdjectives(JCas jcas) {
        for (NEMarkable mark : jcas.getAnnotationIndex(NEMarkable.type)) {
            TreebankNode node = MarkableTreeUtils.markableNode(jcas, mark.getBegin(), mark.getEnd());
            if (!node.getNodeType().equals("JJ")) continue;
            while (node.getNodeType().equals("JJ") && (node = node.getParent()) != null) {
            }
            if (node == null) continue;
            mark.setBegin(node.getBegin());
            mark.setEnd(node.getEnd());
        }
    }

    private static void rmDup(LinkedList<Annotation> markables) {
        HashSet<Annotation> rm = new HashSet<Annotation>();
        HashMap<String, Annotation> keep = new HashMap<String, Annotation>();
        for (int i = 0; i < markables.size(); ++i) {
            Annotation m1 = markables.get(i);
            String key = m1.getBegin() + "-" + m1.getEnd();
            if (!keep.containsKey(key)) {
                keep.put(key, m1);
                continue;
            }
            Annotation m2 = (Annotation)keep.get(key);
            if (m2 instanceof DemMarkable && m1 instanceof NEMarkable) {
                rm.add(m2);
                keep.put(key, m1);
                continue;
            }
            if (m1 instanceof DemMarkable && m2 instanceof NEMarkable) {
                rm.add(m1);
                continue;
            }
            rm.add(m1);
        }
        for (Annotation a : rm) {
            a.removeFromIndexes();
        }
    }
}

