/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Markable Annotator (Deterministic)", description="Annotates Markables for use by Coreference Annotators. degree_of type and a single modifier.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.DEPENDENCY_NODE, PipeBitInfo.TypeProduct.TIMEX}, products={PipeBitInfo.TypeProduct.MARKABLE})
public class DeterministicMarkableAnnotator
extends JCasAnnotator_ImplBase {
    static Pattern headerPatt = Pattern.compile("^(([A-Z][\\.\\:\\)])|(#\\d+)|(\\d+[\\.\\:\\)])) *");

    public void initialize(UimaContext uc) throws ResourceInitializationException {
        super.initialize(uc);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        DeterministicMarkableAnnotator.createMarkablesUsingDependencyTrees(jCas);
        for (TimeMention timex : JCasUtil.select((JCas)jCas, TimeMention.class)) {
            boolean collision = false;
            for (Markable other : JCasUtil.selectCovered((JCas)jCas, Markable.class, (int)timex.getBegin(), (int)timex.getEnd())) {
                if (other.getBegin() != timex.getBegin() || other.getEnd() != timex.getEnd()) continue;
                collision = true;
                break;
            }
            if (collision) continue;
            Markable m = new Markable(jCas, timex.getBegin(), timex.getEnd());
            m.addToIndexes(jCas);
        }
    }

    private static void createMarkablesUsingDependencyTrees(JCas jCas) {
        for (Segment seg : JCasUtil.select((JCas)jCas, Segment.class)) {
            for (ConllDependencyNode node : JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)seg)) {
                String nodeText = node.getCoveredText().toLowerCase();
                List terms = JCasUtil.selectCovered(TerminalTreebankNode.class, (AnnotationFS)node);
                TerminalTreebankNode term = null;
                if (terms.size() > 0) {
                    term = (TerminalTreebankNode)terms.get(0);
                }
                if (node.getId() == 0 || nodeText.matches("\\p{Punct}+")) continue;
                if (node.getPostag().startsWith("NN") && term != null && term.getNodeType().startsWith("N")) {
                    Matcher m;
                    ConllDependencyNode parent;
                    if (node.getForm().matches("\\s+") || nodeText.equals("date") || nodeText.equals("tablet") || nodeText.equals("hg") || nodeText.equals("lb") || nodeText.equals("status") || nodeText.equals("capsule") || nodeText.equals("mg") || nodeText.equals("cm")) continue;
                    int begin = node.getBegin();
                    int end = node.getEnd();
                    List<ConllDependencyNode> progeny = DependencyUtility.getProgeny((ConllDependencyNode)node, (List)DependencyUtility.getDependencyNodes((JCas)jCas, (Annotation)DependencyUtility.getSentence((JCas)jCas, (Annotation)node)));
                    if ((progeny = DeterministicMarkableAnnotator.removeUnannotatedNodes(node, progeny)).size() > 0) {
                        for (ConllDependencyNode child : progeny) {
                            if (child.getBegin() < begin) {
                                begin = child.getBegin();
                            }
                            if (child.getEnd() <= end) continue;
                            end = child.getEnd();
                        }
                    }
                    if ((parent = node.getHead()) != null && parent.getId() != 0) {
                        if (parent.getBegin() < node.getBegin() && parent.getBegin() > begin) {
                            BaseToken nextToken = (BaseToken)JCasUtil.selectFollowing(BaseToken.class, (AnnotationFS)parent, (int)1).get(0);
                            begin = nextToken.getBegin();
                        }
                        if (parent.getEnd() > node.getEnd() && parent.getEnd() < end) {
                            BaseToken prevToken = (BaseToken)JCasUtil.selectPreceding(BaseToken.class, (AnnotationFS)parent, (int)1).get(0);
                            end = prevToken.getEnd();
                        }
                    }
                    if ((m = headerPatt.matcher(nodeText)).find()) {
                        begin += m.end();
                    }
                    Markable markable = new Markable(jCas, begin, end);
                    markable.addToIndexes();
                    continue;
                }
                if (node.getPostag().equals("DT") && !node.getDeprel().equals("det")) {
                    Markable markable = new Markable(jCas, node.getBegin(), node.getEnd());
                    markable.addToIndexes();
                    continue;
                }
                if (!node.getCoveredText().toLowerCase().equals("it") || !node.getDeprel().contains("bj")) continue;
                Markable markable = new Markable(jCas, node.getBegin(), node.getEnd());
                markable.addToIndexes();
            }
        }
    }

    private static List<ConllDependencyNode> removeUnannotatedNodes(ConllDependencyNode originalNode, List<ConllDependencyNode> progeny) {
        ArrayList<ConllDependencyNode> filtered = new ArrayList<ConllDependencyNode>();
        for (ConllDependencyNode node : progeny) {
            if (node == originalNode) {
                filtered.add(node);
            }
            boolean blockedByConj = false;
            for (ConllDependencyNode pathEl : DependencyUtility.getPath(progeny, (ConllDependencyNode)node, (ConllDependencyNode)originalNode)) {
                if (pathEl == originalNode || !pathEl.getDeprel().equals("conj") && !pathEl.getDeprel().equals("cc") && !pathEl.getPostag().equals(".") && !pathEl.getPostag().equals(",") && !pathEl.getDeprel().equals("punct") && !pathEl.getDeprel().equals("meta") && !pathEl.getCoveredText().matches("(([A-Z][\\.\\:\\)])|(#\\d+)|(\\d+[\\.\\:\\)]))")) continue;
                blockedByConj = true;
                break;
            }
            if (blockedByConj) continue;
            filtered.add(node);
        }
        return filtered;
    }

    private static void createMarkablesUsingConstituencyTrees(JCas jCas) {
        for (TreebankNode tree : JCasUtil.select((JCas)jCas, TreebankNode.class)) {
            if (!tree.getNodeType().equals("NP")) continue;
            String nodeText = tree.getCoveredText();
            if (tree.getChildren().size() == 1 && (tree.getChildren(0).getNodeType().equals("PRP") || tree.getChildren(0).getNodeType().equals("EX") || tree.getChildren(0).getNodeType().equals("CD"))) continue;
            Markable markable = null;
            Matcher m = headerPatt.matcher(nodeText);
            int start = tree.getBegin();
            int end = tree.getEnd();
            if (m.find()) {
                start += m.end();
            }
            if ((nodeText.endsWith(".") || nodeText.endsWith(":")) && end - 1 > start) {
                --end;
            }
            markable = new Markable(jCas, start, end);
            markable.addToIndexes();
            for (int i = 0; i < tree.getChildren().size() - 1; ++i) {
                TreebankNode child = tree.getChildren(i);
                if (!(child instanceof TerminalTreebankNode) || !child.getNodeType().startsWith("N") || child.getNodeType().equals("NNP")) continue;
                markable = new Markable(jCas, child.getBegin(), child.getEnd());
                markable.addToIndexes();
            }
        }
    }
}

