/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.utils.Interval;

public class OverlapIterator<I extends Comparable<? super I>, V> {
    int nextToInclude;
    final List<Interval<I, V>> sortedByMin;
    int nextToExclude;
    final List<Interval<I, V>> sortedByMax;
    final Set<V> overlaps = new HashSet<V>();
    final Set<V> accessible = Collections.unmodifiableSet(this.overlaps);

    public OverlapIterator(Collection<Interval<I, V>> intervals) {
        this.sortedByMax = new ArrayList<Interval<I, V>>(intervals);
        Collections.sort(this.sortedByMax, Interval.maxOrdering());
        this.sortedByMin = new ArrayList<Interval<I, V>>(this.sortedByMax);
        Collections.sort(this.sortedByMin, Interval.minOrdering());
    }

    public void update(I point) {
        while (this.nextToInclude < this.sortedByMin.size() && ((Comparable)this.sortedByMin.get((int)this.nextToInclude).min).compareTo(point) <= 0) {
            this.overlaps.add(this.sortedByMin.get((int)this.nextToInclude++).data);
        }
        while (this.nextToExclude < this.sortedByMax.size() && ((Comparable)this.sortedByMax.get((int)this.nextToExclude).max).compareTo(point) < 0) {
            this.overlaps.remove(this.sortedByMax.get((int)this.nextToExclude++).data);
        }
    }

    public Set<V> overlaps() {
        return this.accessible;
    }
}

