/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.runtimecatalog;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.camel.runtimecatalog.Pair;
import org.apache.camel.runtimecatalog.UnsafeUriCharactersEncoder;

public final class URISupport {
    public static final String RAW_TOKEN_PREFIX = "RAW";
    public static final char[] RAW_TOKEN_START = new char[]{'(', '{'};
    public static final char[] RAW_TOKEN_END = new char[]{')', '}'};
    private static final String CHARSET = "UTF-8";

    private URISupport() {
    }

    public static URI normalizeUri(String uri) throws URISyntaxException {
        return new URI(UnsafeUriCharactersEncoder.encode(uri, true));
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            it.remove();
        }
        return rc;
    }

    public static String stripQuery(String uri) {
        int idx = uri.indexOf(63);
        if (idx > -1) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    public static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.indexOf(63);
            if (idx < 0) {
                return new LinkedHashMap<String, Object>(0);
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return URISupport.parseQuery(query);
    }

    public static String stripPrefix(String value, String prefix) {
        if (value != null && value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return URISupport.parseQuery(uri, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        if (URISupport.isEmpty(uri)) {
            return new LinkedHashMap<String, Object>(0);
        }
        if (uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        try {
            LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>();
            boolean isKey = true;
            boolean isValue = false;
            boolean isRaw = false;
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < uri.length(); ++i) {
                char ch = uri.charAt(i);
                char next = i <= uri.length() - 2 ? uri.charAt(i + 1) : (char)'\u0000';
                char rawTokenEnd = '\u0000';
                for (int j = 0; j < RAW_TOKEN_START.length; ++j) {
                    String rawTokenStart = RAW_TOKEN_PREFIX + RAW_TOKEN_START[j];
                    isRaw = value.toString().startsWith(rawTokenStart);
                    if (!isRaw) continue;
                    rawTokenEnd = RAW_TOKEN_END[j];
                    break;
                }
                if (isRaw) {
                    boolean end;
                    if (isKey) {
                        key.append(ch);
                    } else if (isValue) {
                        value.append(ch);
                    }
                    boolean bl = end = ch == rawTokenEnd && (next == '&' || next == '\u0000');
                    if (!end) continue;
                    URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
                    key.setLength(0);
                    value.setLength(0);
                    isKey = true;
                    isValue = false;
                    isRaw = false;
                    ++i;
                    continue;
                }
                if (isKey && ch == '=') {
                    isKey = false;
                    isValue = true;
                    isRaw = false;
                    continue;
                }
                if (ch == '&') {
                    boolean validKey;
                    String aKey = key.toString();
                    boolean bl = validKey = !aKey.startsWith("{{") && !aKey.endsWith("}}");
                    if (validKey) {
                        URISupport.addParameter(aKey, value.toString(), rc, useRaw || isRaw);
                    }
                    key.setLength(0);
                    value.setLength(0);
                    isKey = true;
                    isValue = false;
                    isRaw = false;
                    continue;
                }
                if (isKey) {
                    key.append(ch);
                    continue;
                }
                if (!isValue) continue;
                value.append(ch);
            }
            if (key.length() > 0) {
                boolean validKey;
                String aKey = key.toString();
                boolean bl = validKey = !aKey.startsWith("{{") && !aKey.endsWith("}}");
                if (validKey) {
                    URISupport.addParameter(aKey, value.toString(), rc, useRaw || isRaw);
                }
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void addParameter(String name, String value, Map<String, Object> map, boolean isRaw) throws UnsupportedEncodingException {
        name = URLDecoder.decode(name, CHARSET);
        if (!isRaw) {
            value = URLDecoder.decode(value.replaceAll("%", "%25"), CHARSET);
        }
        if (map.containsKey(name)) {
            ArrayList<String> list;
            Object existing = map.get(name);
            if (existing instanceof List) {
                list = (ArrayList<String>)existing;
            } else {
                String s;
                list = new ArrayList<String>();
                String string = s = existing != null ? existing.toString() : null;
                if (s != null) {
                    list.add(s);
                }
            }
            list.add(value);
            map.put(name, list);
        } else {
            map.put(name, value);
        }
    }

    public static List<Pair<Integer>> scanRaw(String str) {
        ArrayList<Pair<Integer>> answer = new ArrayList<Pair<Integer>>();
        if (str == null || URISupport.isEmpty(str)) {
            return answer;
        }
        int offset = 0;
        int start2 = str.indexOf(RAW_TOKEN_PREFIX);
        while (start2 >= 0 && offset < str.length()) {
            offset = start2 + RAW_TOKEN_PREFIX.length();
            for (int i = 0; i < RAW_TOKEN_START.length; ++i) {
                String tokenStart = RAW_TOKEN_PREFIX + RAW_TOKEN_START[i];
                char tokenEnd = RAW_TOKEN_END[i];
                if (!str.startsWith(tokenStart, start2)) continue;
                offset = URISupport.scanRawToEnd(str, start2, tokenStart, tokenEnd, answer);
            }
            start2 = str.indexOf(RAW_TOKEN_PREFIX, offset);
        }
        return answer;
    }

    private static int scanRawToEnd(String str, int start2, String tokenStart, char tokenEnd, List<Pair<Integer>> answer) {
        int end = str.indexOf(tokenEnd, start2 + tokenStart.length());
        if (end < 0) {
            answer.add(new Pair<Integer>(start2, str.length()));
            return str.length();
        }
        answer.add(new Pair<Integer>(start2, end));
        return end + 1;
    }

    public static boolean isRaw(int index, List<Pair<Integer>> pairs) {
        for (Pair<Integer> pair : pairs) {
            if (index < pair.getLeft()) {
                return false;
            }
            if (index > pair.getRight()) continue;
            return true;
        }
        return false;
    }

    private static boolean resolveRaw(String str, BiConsumer<String, String> consumer) {
        for (int i = 0; i < RAW_TOKEN_START.length; ++i) {
            String tokenStart = RAW_TOKEN_PREFIX + RAW_TOKEN_START[i];
            String tokenEnd = String.valueOf(RAW_TOKEN_END[i]);
            if (!str.startsWith(tokenStart) || !str.endsWith(tokenEnd)) continue;
            String raw = str.substring(tokenStart.length(), str.length() - 1);
            consumer.accept(str, raw);
            return true;
        }
        return false;
    }

    public static String createQueryString(Map<String, String> options, String ampersand, boolean encode) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuilder rc = new StringBuilder();
                boolean first = true;
                for (String o : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append(ampersand);
                    }
                    String key = o;
                    String value = options.get(key);
                    String s = value != null ? value.toString() : null;
                    URISupport.appendQueryStringParameter(key, s, rc, encode);
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void appendQueryStringParameter(String key, String value, StringBuilder rc, boolean encode) throws UnsupportedEncodingException {
        if (encode) {
            rc.append(URLEncoder.encode(key, CHARSET));
        } else {
            rc.append(key);
        }
        if (value == null) {
            return;
        }
        rc.append("=");
        boolean isRaw = URISupport.resolveRaw(value, (str, raw) -> rc.append((String)str));
        if (!isRaw) {
            if (encode) {
                rc.append(URLEncoder.encode(value, CHARSET));
            } else {
                rc.append(value);
            }
        }
    }

    public static boolean isEmpty(Object value) {
        return !URISupport.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        return true;
    }
}

