import QtQuick
import QtQuick3D

Node {
    scale.z: 100
    scale.y: 100
    scale.x: 100
    // Materials
    // end of Materials

    Node {
        id: rOOT
        eulerRotation.x: 90
        Model {
            id: inner_race
            source: "meshes/cylinder_004.mesh"
            materials: [
                ballBearing_material
            ]
        }
        Model {
            id: balls
            source: "meshes/cube_006.mesh"
            materials: [
                ballBearing_material
            ]
        }
        Model {
            id: retainer
            source: "meshes/cube_007.mesh"
            materials: [
                ballBearing_material
            ]
        }
        Model {
            id: shield_left
            source: "meshes/cylinder_005.mesh"
            materials: [
                ballBearing_material
            ]
        }
        Model {
            id: shield_right
            source: "meshes/cylinder_006.mesh"
            materials: [
                ballBearing_material
            ]
        }
        Model {
            id: outer_race
            source: "meshes/cylinder_007.mesh"
            materials: [
                ballBearing_material
            ]
        }
    }

    Node {
        id: __materialLibrary__
        PrincipledMaterial {
            id: ballBearing_material
            opacityChannel: Material.A
            roughness: 1
            metalnessChannel: Material.B
            alphaMode: PrincipledMaterial.Opaque
            roughnessMap: Texture {
                source: "maps/BallBearing_BallBearing_OcclusionRoughnessMetallic.png"
                mipFilter: Texture.Linear
                generateMipmaps: true
            }
            metalnessMap: Texture {
                source: "maps/BallBearing_BallBearing_OcclusionRoughnessMetallic.png"
                mipFilter: Texture.Linear
                generateMipmaps: true
            }
            cullMode: Material.NoCulling
            baseColorMap: Texture {
                source: "maps/BallBearing_BallBearing_BaseColor.png"
                mipFilter: Texture.Linear
                generateMipmaps: true
            }
            objectName: "ballBearing_material"
            roughnessChannel: Material.G
            normalMap: Texture {
                source: "maps/BallBearing_BallBearing_Normal.png"
                mipFilter: Texture.Linear
                generateMipmaps: true
            }
            metalness: 1
        }

        PrincipledMaterial {
            id: _material
            alphaMode: PrincipledMaterial.Opaque
            roughness: 1
            objectName: "_material"
            metalness: 1
        }
    }
}
