untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajUhw32hGY/LxQSg09yt/tebyQzx/kSGT5t+XshrhbQvtZPvDTz25y6vjPwHCu9hc1hOh/87tsI6Jb2qNoYOZMw4=

OpenBSD 7.4 errata 004, November 21, 2023:

Simple passwords which were 8 characters long caused ospfd(8) to
send out packets with invalid checksum.

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 004_ospfd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install ospfd(8):
    cd /usr/src/usr.sbin/ospfd
    make obj
    make
    make install

Index: usr.sbin/ospfd/auth.c
===================================================================
RCS file: /cvs/src/usr.sbin/ospfd/auth.c,v
diff -u -p -r1.22 auth.c
--- usr.sbin/ospfd/auth.c	3 Jul 2023 09:40:47 -0000	1.22
+++ usr.sbin/ospfd/auth.c	18 Nov 2023 16:57:29 -0000
@@ -166,7 +166,8 @@ auth_gen(struct ibuf *buf, struct iface 
 			fatalx("auth_gen: ibuf_set failed");
 
 		if (ibuf_set(buf, offsetof(struct ospf_hdr, auth_key),
-		    iface->auth_key, strlen(iface->auth_key)) == -1)
+		    iface->auth_key, strnlen(iface->auth_key,
+		    sizeof(iface->auth_key))) == -1)
 			fatalx("auth_gen: ibuf_set failed");
 		break;
 	case AUTH_CRYPT:
