untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2jLgJhR7mVeG6VZI7OwX8hA1RXwM89PPvNmfyLLVCj+/nWYt+dKgFwT8bQXGbi097JWkK5RlN0dGcUamKTdzbw0=

OpenBSD 6.8 errata 004, November 05, 2020:

wg(4) could panic the kernel by releasing the wrong lock.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 004_wg.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/wg_noise.c
===================================================================
RCS file: /cvs/src/sys/net/wg_noise.c,v
retrieving revision 1.1
diff -u -p -r1.1 wg_noise.c
--- sys/net/wg_noise.c	21 Jun 2020 12:11:26 -0000	1.1
+++ sys/net/wg_noise.c	3 Nov 2020 12:29:50 -0000
@@ -459,7 +459,7 @@ noise_remote_begin_session(struct noise_
 		    NOISE_SYMMETRIC_KEY_LEN, NOISE_SYMMETRIC_KEY_LEN, 0, 0,
 		    hs->hs_ck);
 	} else {
-		rw_exit_write(&r->r_keypair_lock);
+		rw_exit_write(&r->r_handshake_lock);
 		return EINVAL;
 	}
 
