untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3qgveV5NmJXn0wO+xWedVlmGlfV7a+6aFXOuIbUn2WaJz/M46hhdOIttWTGgl/DxX16gjO9IgUt4QpxxOq8OUQA=

OpenBSD 6.7 errata 027, October 29, 2020:

tmux has a stack overflow in CSI parsing.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 027_tmux.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install tmux:
    cd /usr/src/usr.bin/tmux
    make obj
    make
    make install

Index: usr.bin/tmux/input.c
===================================================================
RCS file: /cvs/src/usr.bin/tmux/input.c,v
diff -u -p -u -r1.174 input.c
--- usr.bin/tmux/input.c	30 Apr 2020 13:31:22 -0000	1.174
+++ usr.bin/tmux/input.c	29 Oct 2020 15:35:12 -0000
@@ -1968,8 +1968,13 @@ input_csi_dispatch_sgr_colon(struct inpu
 				free(copy);
 				return;
 			}
-		} else
+		} else {
 			n++;
+			if (n == nitems(p)) {
+				free(copy);
+				return;
+			}
+		}
 		log_debug("%s: %u = %d", __func__, n - 1, p[n - 1]);
 	}
 	free(copy);
