untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEkpq7n8ALOeGORiKmP4CJFUl/4Pu3VbherjEnZGJ0vvKM+93JrlaIUDViKiFwXMREDH7zxD7Om37hVodlukI2gM=

OpenBSD 6.1 errata 038, March 20, 2018:

The IPsec AH header could be longer than the network packet.
This may cause a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 038_ahauth.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_ah.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_ah.c,v
retrieving revision 1.129.4.1
diff -u -p -r1.129.4.1 ip_ah.c
--- sys/netinet/ip_ah.c	1 Feb 2018 22:07:24 -0000	1.129.4.1
+++ sys/netinet/ip_ah.c	14 Mar 2018 23:23:26 -0000
@@ -583,7 +583,16 @@ ah_input(struct mbuf *m, struct tdb *tdb
 		    "in SA %s/%08x\n", hl * sizeof(u_int32_t),
 		    ipsp_address(&tdb->tdb_dst, buf, sizeof(buf)),
 		    ntohl(tdb->tdb_spi)));
-
+		ahstat.ahs_badauthl++;
+		m_freem(m);
+		return EACCES;
+	}
+	if (skip + ahx->authsize + rplen > m->m_pkthdr.len) {
+		DPRINTF(("%s: bad mbuf length %d (expecting %d) "
+		    "for packet in SA %s/%08x\n", __func__,
+		    m->m_pkthdr.len, skip + ahx->authsize + rplen,
+		    ipsp_address(&tdb->tdb_dst, buf, sizeof(buf)),
+		    ntohl(tdb->tdb_spi)));
 		ahstat.ahs_badauthl++;
 		m_freem(m);
 		return EACCES;
